<?php
include '../includes/connection.inc';
include '../query/maxim.sql';

function correctImageOrientation($filename) {
  if (function_exists('exif_read_data')) {
    $exif = exif_read_data($filename);
    if($exif && isset($exif['Orientation'])) {
      $orientation = $exif['Orientation'];
      if($orientation != 1){
        $img = imagecreatefromjpeg($filename);
        $deg = 0;
        switch ($orientation) {
          case 3:
            $deg = 180;
            break;
          case 6:
            $deg = 270;
            break;
          case 8:
            $deg = 90;
            break;
        }
        if ($deg) {
          $img = imagerotate($img, $deg, 0);        
        }
        // then rewrite the rotated image back to the disk as $filename 
        imagejpeg($img, $filename, 95);
      } // if there is some rotation necessary
    } // if have the exif orientation info
  } // if function exists      
}

function resize_crop_image($max_width, $max_height, $source_file, $dst_dir, $quality = 80){
    $imgsize = getimagesize($source_file);
    $width = $imgsize[0];
    $height = $imgsize[1];
    $mime = $imgsize['mime'];
 
    switch($mime){
        case 'image/gif':
            $image_create = "imagecreatefromgif";
            $image = "imagegif";
            break;
 
        case 'image/png':
            $image_create = "imagecreatefrompng";
            $image = "imagepng";
            $quality = 7;
            break;
 
        case 'image/jpeg':
            $image_create = "imagecreatefromjpeg";
            $image = "imagejpeg";
            $quality = 80;
            break;
 
        default:
            return false;
            break;
    }
     
    $dst_img = imagecreatetruecolor($max_width, $max_height);
    $src_img = $image_create($source_file);
     
    $width_new = $height * $max_width / $max_height;
    $height_new = $width * $max_height / $max_width;
    //if the new width is greater than the actual width of the image, then the height is too large and the rest cut off, or vice versa
    if($width_new > $width){
        //cut point by height
        $h_point = (($height - $height_new) / 2);
        //copy image
        imagecopyresampled($dst_img, $src_img, 0, 0, 0, $h_point, $max_width, $max_height, $width, $height_new);
    }else{
        //cut point by width
        $w_point = (($width - $width_new) / 2);
        imagecopyresampled($dst_img, $src_img, 0, 0, $w_point, 0, $max_width, $max_height, $width_new, $height);
    }
     
    $image($dst_img, $dst_dir, $quality);
 
    if($dst_img)imagedestroy($dst_img);
    if($src_img)imagedestroy($src_img);
}

$arrayCreated=explode('|',$_SESSION['MAXIM_AUTH']);

$nmx=$_REQUEST['nmx'];
$editnmx=$_REQUEST['editnmx'];

$fullname=trim($_REQUEST['fullname']);
$birthdate=date('Y-m-d',strtotime($_REQUEST['birthdate']));
$gender=$_REQUEST['gender'];
$whatsapp=$_REQUEST['whatsapp'];
if(substr($whatsapp,0,1)=='0') {
	$whatsapp='62'.substr($whatsapp,1,strlen($whatsapp)-1);
}
$email=trim(strtolower($_REQUEST['email']));
$membertype=$_REQUEST['membertype'];
$licence=$_REQUEST['licence'];
$identitynumber=trim($_REQUEST['identitynumber']);
$gate=strtoupper(str_replace(' ','',trim($_REQUEST['gate'])));
$memberaddress=strtolower(trim($_REQUEST['memberaddress']));
$memberprovince=$_REQUEST['memberprovince'];
$membercity=$_REQUEST['membercity'];
$memberkecamatan=$_REQUEST['memberkecamatan'];
$memberkelurahan=$_REQUEST['memberkelurahan'];
$memberpostal=$_REQUEST['memberpostal'];
$sauna=$_REQUEST['sauna'];
$discount=$_REQUEST['discount'];
$memberperiod='1';
$member_delete=$_REQUEST['member_delete'];
$target_dir = "../assets/img/memberphoto/";



$target_file = $target_dir . basename($_FILES['memberimage']['name']);
$imageFileType = strtolower(pathinfo($target_file,PATHINFO_EXTENSION));

$result='failed';

if($nmx) {
		$memberExpired=date('Y-m-d');
		if($_FILES['memberimage']['name'] == "") {
				mysqli_query($conn,"INSERT INTO member_m SET 
				member_fullname='".ucwords(strtolower(mysqli_real_escape_string($conn,$fullname)))."',
				member_licence='".$licence."',
				member_licence_number='".$identitynumber."',
				member_birthdate='".$birthdate."',
				member_gender='".$gender."',
				member_province='".$memberprovince."',
				member_city='".$membercity."',
				member_kecamatan='".$memberkecamatan."',
				member_kelurahan='".$memberkelurahan."',
				member_postal='".$memberpostal."',
				member_address='".ucwords(mysqli_real_escape_string($conn,$memberaddress))."',
				member_type='".$membertype."',
				member_whatsapp='".$whatsapp."',
				member_email='".$email."',
				member_sauna='".$sauna."',
				member_cardnumber='".$gate."',
				member_uid='".$nmx."',
				member_rate=".$discount.",
				created_by='".$arrayCreated[1]."',
				member_period='".$memberperiod."',
				member_start='".date('Y-m-d')."',
				member_expire='".$memberExpired."'");
				$result='success';
		} else {
			if(move_uploaded_file($_FILES['memberimage']['tmp_name'],$target_dir.$nmx.".".$imageFileType)) {	
				mysqli_query($conn,"INSERT INTO member_m SET 
				member_fullname='".ucwords(strtolower(mysqli_real_escape_string($conn,$fullname)))."',
				member_licence='".$licence."',
				member_licence_number='".$identitynumber."',
				member_birthdate='".$birthdate."',
				member_gender='".$gender."',
				member_province='".$memberprovince."',
				member_city='".$membercity."',
				member_kecamatan='".$memberkecamatan."',
				member_kelurahan='".$memberkelurahan."',
				member_postal='".$memberpostal."',
				member_address='".ucwords(mysqli_real_escape_string($conn,$memberaddress))."',
				member_type='".$membertype."',
				member_whatsapp='".$whatsapp."',
				member_email='".$email."',
				member_sauna='".$sauna."',
				member_cardnumber='".$gate."',
				member_uid='".$nmx."',
				member_rate=".$discount.",
				created_by='".$arrayCreated[1]."',
				member_period='".$memberperiod."',
				member_start='".date('Y-m-d')."',
				member_expire='".$memberExpired."',
				member_photo='".$nmx.".".$imageFileType."'");
				$result='success';
			} 
		}
		
} else {
	if($_FILES['memberimage']['name'] != "") {
		if(move_uploaded_file($_FILES['memberimage']['tmp_name'],$target_dir.$editnmx.".".$imageFileType)) {	
				mysqli_query($conn,"UPDATE member_m SET 
				member_fullname='".ucwords(strtolower(mysqli_real_escape_string($conn,$fullname)))."',
				member_licence='".$licence."',
				member_licence_number='".$identitynumber."',
				member_birthdate='".$birthdate."',
				member_gender='".$gender."',
				member_province='".$memberprovince."',
				member_city='".$membercity."',
				member_kecamatan='".$memberkecamatan."',
				member_kelurahan='".$memberkelurahan."',
				member_postal='".$memberpostal."',
				member_address='".ucwords(mysqli_real_escape_string($conn,$memberaddress))."',
				member_type='".$membertype."',
				member_whatsapp='".$whatsapp."',
				member_email='".$email."',
				member_sauna='".$sauna."',
				member_cardnumber='".$gate."',
				member_rate=".$discount.",
				last_modified='".date('Y-m-d')."',
				modified_by='".$arrayCreated[1]."',
				member_period='".$memberperiod."',
				member_active='".$member_delete."',
				member_photo='".$editnmx.".".$imageFileType."' WHERE member_uid='".$editnmx."'");
				$result='success';
		} 
	} else {
				mysqli_query($conn,"UPDATE member_m SET 
				member_fullname='".ucwords(strtolower(mysqli_real_escape_string($conn,$fullname)))."',
				member_licence='".$licence."',
				member_licence_number='".$identitynumber."',
				member_birthdate='".$birthdate."',
				member_gender='".$gender."',
				member_province='".$memberprovince."',
				member_city='".$membercity."',
				member_kecamatan='".$memberkecamatan."',
				member_kelurahan='".$memberkelurahan."',
				member_postal='".$memberpostal."',
				member_address='".ucwords(mysqli_real_escape_string($conn,$memberaddress))."',
				member_type='".$membertype."',
				member_whatsapp='".$whatsapp."',
				member_email='".$email."',
				member_sauna='".$sauna."',
				member_cardnumber='".$gate."',
				member_rate=".$discount.",
				last_modified='".date('Y-m-d')."',
				modified_by='".$arrayCreated[1]."',
				member_period='".$memberperiod."',
				member_active='".$member_delete."' WHERE member_uid='".$editnmx."'");
				$result='success';
	}
}

	echo $result;

include '../includes/connection_close.inc';
?>