<?php
include '../../includes/connection.inc';
include '../../query/maxim.sql';
include '../../includes/header.inc';
?>
    
    
    <!-- BEGIN PAGE LEVEL STYLES -->
    <link rel="stylesheet" type="text/css" href="<?php echo ROOT_URL;?>plugins/table/datatable/datatables.css">
    <link rel="stylesheet" type="text/css" href="<?php echo ROOT_URL;?>plugins/table/datatable/dt-global_style.css">
    <link rel="stylesheet" type="text/css" href="<?php echo ROOT_URL;?>plugins/table/datatable/custom_dt_multiple_tables.css">
	<link href="<?php echo ROOT_URL;?>plugins/animate/animate.css" rel="stylesheet" type="text/css" />
	<link href="<?php echo ROOT_URL;?>assets/css/scrollspyNav.css" rel="stylesheet" type="text/css" />
    <link href="<?php echo ROOT_URL;?>assets/css/components/custom-modal.css" rel="stylesheet" type="text/css" />
	<link rel="stylesheet" type="text/css" href="<?php echo ROOT_URL;?>assets/css/forms/switches.css">
	<link href="<?php echo ROOT_URL;?>assets/css/components/tabs-accordian/custom-accordions.css" rel="stylesheet" type="text/css" />
    <!-- END PAGE LEVEL STYLES -->
	
	<!-- BEGIN THEME GLOBAL STYLES -->
    <link href="<?php echo ROOT_URL;?>assets/css/scrollspyNav.css" rel="stylesheet" type="text/css" />
    <link href="<?php echo ROOT_URL;?>plugins/animate/animate.css" rel="stylesheet" type="text/css" />
    <script src="<?php echo ROOT_URL;?>plugins/sweetalerts/promise-polyfill.js"></script>
    <link href="<?php echo ROOT_URL;?>plugins/sweetalerts/sweetalert2.min.css" rel="stylesheet" type="text/css" />
    <link href="<?php echo ROOT_URL;?>plugins/sweetalerts/sweetalert.css" rel="stylesheet" type="text/css" />
    <link href="<?php echo ROOT_URL;?>assets/css/components/custom-sweetalert.css" rel="stylesheet" type="text/css" />
	<link href="<?php echo ROOT_URL;?>plugins/file-upload/file-upload-with-preview.min.css" rel="stylesheet" type="text/css" />
</head>
<?php
$arrayUid = explode('|',$_SESSION['MAXIM_AUTH']);
CheckUserAccessCurrentMenuPage($conn,$arrayUid[1],'MNU009');
?>
<body class="sidebar-noneoverflow">
    <!-- BEGIN LOADER -->
    <div id="load_screen"> <div class="loader"> <div class="loader-content">
        <div class="spinner-grow align-self-center"></div>
    </div></div></div>
    <!--  END LOADER -->
    
    <!--  BEGIN NAVBAR  -->
    <?php include '../../includes/navbar.inc';?>
    <!--  END NAVBAR  -->

    <!--  BEGIN MAIN CONTAINER  -->
    <div class="main-container" id="container">

        <div class="overlay"></div>
        <div class="cs-overlay"></div>
        <div class="search-overlay"></div>

        <!--  BEGIN SIDEBAR  -->
        <?php include '../../includes/sidebar.inc';?>
        <!--  END SIDEBAR  -->

        <!--  BEGIN CONTENT AREA  -->
        <div id="content" class="main-content">
            <div class="layout-px-spacing">
                
                <div class="row layout-top-spacing" id="cancel-row">

                    <div class="col-xl-12 col-lg-12 col-sm-12  layout-spacing">
						<div class="row">
							<div class="col"><h3 style="color:<?php echo BASE_COLOR;?>;">Paket Trainee</h3></div>
							<div class="col text-right"><button title="registrasi" class="btn btn-dark mb-2 mr-2 rounded-circle" onclick="FormNewPacket('open');"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-plus"><line x1="12" y1="5" x2="12" y2="19"></line><line x1="5" y1="12" x2="19" y2="12"></line></svg></button></div>
						</div>
                        <div class="widget-content widget-content-area br-6">
                            
                            <table class="multi-table table table-striped table-bordered table-hover non-hover" style="width:100%">
                                <thead>
                                    <tr>
										<th class="text-center">Paket</th>
										<th class="text-center dt-no-sorting">Sesi</th>
										<th class="text-center dt-no-sorting">Harga</th>
                                        <th class="text-center">Aktif</th>
                                        <th class="text-center dt-no-sorting">&nbsp;</th>
                                    </tr>
                                </thead>
                                <tbody>
									<?php
									$arrayTrainee=PacketTrainee($conn,'','');
									$jsonTrainee=json_decode($arrayTrainee);
									foreach($jsonTrainee as $jsontrainee) {
										if($jsontrainee->packet_active=='YY') {
											$status='<span class="badge badge-success" style="width:74px;"> Aktif </span>';
										} else {
											$status='<span class="badge badge-danger"> Tidak Aktif</span>';
										}
									?>
									<tr>
										<td class="text-black"><?php echo $jsontrainee->packet_name;?></td>
                                        <td class="text-black"><?php echo $jsontrainee->packet_session;?> sesi</td>
										<td class="text-right text-black">Rp.&nbsp;<?php echo number_format($jsontrainee->packet_price);?></td>
										<td class="text-center text-black"><?php echo $status;?></td>
                                        <td class="text-center">
											<button onclick="ShowDataTrainee('<?php echo $jsontrainee->packet_code;?>')" title="edit" class="btn btn-warning mb-2 mr-2 rounded-circle"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-edit-3"><path d="M12 20h9"></path><path d="M16.5 3.5a2.121 2.121 0 0 1 3 3L7 19l-4 1 1-4L16.5 3.5z"></path></svg></button>
										</td>
                                    </tr>
									<?php
									}
									?>
                                </tbody>
                                <tfoot>
                                    <tr>
										<th class="text-center">Paket</th>
										<th class="text-center dt-no-sorting">Sesi</th>
										<th class="text-center dt-no-sorting">Harga</th>
                                        <th class="text-center">Aktif</th>
                                        <th class="text-center dt-no-sorting">&nbsp;</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>

                </div>

                </div>
        <?php include '../../includes/footer.inc';?>
        </div>
        <!--  END CONTENT AREA  -->

    </div>
    <!-- END MAIN CONTAINER -->
    
	<!-- Modal -->
	<!-- Modal -->
	<div id="mdlNewPacket" class="modal animated rotateInDownLeft custo-rotateInDownLeft" role="dialog">
		<div class="modal-dialog  modal-lg">
			<!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header" style="background-color:<?php echo BASE_COLOR;?>;">
					<h5 class="modal-title" style="color:white;">PAKET TRAINEE</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <svg style="color:white;" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-x"><line x1="18" y1="6" x2="6" y2="18"></line><line x1="6" y1="6" x2="18" y2="18"></line></svg>
                    </button>
                </div>
                <div class="modal-body">
					<p class="modal-text">
									<form class="mdal-text" method="post" name="frmRegistration" id="frmRegistration" action="../../actions/trainee_registration.php" enctype="multipart/form-data">
										<input type="hidden" name="edittrainee" id="edittrainee">
			                            <div class="form-row mb-4">
                                            <div class="form-group col-md-3">
                                                <label for="inputEmail4">Nama Paket</label>
                                                <input type="text" class="form-control text-capitalize" id="packetname" name="packetname" maxlength="40" required>
                                            </div>
                                            <div class="form-group col-md-3">
                                                <label for="inputPassword4">Jumlah Sesi</label>
                                                <input type="number" class="form-control" name="packetduration" id="packetduration" value="10" min="1" max="30" required>
                                            </div>
											<div class="form-group col-md-3">
												<label for="inputAddress">Harga (Rp)</label>
												<input type="text" placeholder="0" class="form-control" name="packetprice" id="packetprice" required>
											</div>
											<div class="form-group col-md-3">
												<label for="inputAddress">Aktif</label>
												<select class="form-control" disabled name="packetactive" id="packetactive" required>
													<option value="" selected disabled></option>
													<option value="YY">Ya</option>
													<option value="NN">Tidak</option>
												</select>
											</div>
										</div>
										
										<div class="modal-footer md-button" style="background-color:white;">
											<button class="btn" data-dismiss="modal" onclick="NewUserClose();"><i class="flaticon-cancel-12"></i> Batal</button>
											<button type="submit" class="btn btn-primary" name="btnSaveMember" id="btnSaveMember">Simpan</button>
											</form>
										</div>
					</p>
                </div>
            </div>
        </div>
	</div>
	
	<div class="modal fade modal-notification" id="confirmModal" tabindex="-1" role="dialog" aria-labelledby="standardModalLabel" aria-hidden="true">
		<div class="modal-dialog" role="document" id="standardModalLabel">
			<div class="modal-content" style="background-color:#546e7a;">
				<div class="modal-body text-center">
					<div class="icon-content">
						<svg xmlns="http://www.w3.org/2000/svg" style="color:red;" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-briefcase"><rect x="2" y="7" width="20" height="14" rx="2" ry="2"></rect><path d="M16 21V5a2 2 0 0 0-2-2h-4a2 2 0 0 0-2 2v16"></path></svg>
                    </div>
                    <p class="modal-text text-white">Simpan data member ?</p>
                </div>
                <div class="modal-footer justify-content-between">
					<button class="btn" onclick="CloseConfirmModal();"><i class="flaticon-cancel-12"></i> Tidak</button>
                    <button type="button" class="btn btn-warning" name="btnConfirmSave" id="btnConfirmSave">Ya, Simpan</button>
                </div>
            </div>
        </div>
    </div>
	<!-- End of Modal -->	
    
    <!-- BEGIN GLOBAL MANDATORY SCRIPTS -->
    <script src="<?php echo ROOT_URL;?>assets/js/libs/jquery-3.1.1.min.js"></script>
    <script src="<?php echo ROOT_URL;?>bootstrap/js/popper.min.js"></script>
    <script src="<?php echo ROOT_URL;?>bootstrap/js/bootstrap.min.js"></script>
    <script src="<?php echo ROOT_URL;?>plugins/perfect-scrollbar/perfect-scrollbar.min.js"></script>
	<script src="<?php echo ROOT_URL;?>plugins/blockui/jquery.blockUI.min.js"></script>
    <script src="<?php echo ROOT_URL;?>assets/js/app.js"></script>
    
    <script>
        $(document).ready(function() {
            App.init();
        });
    </script>
	<script src="<?php echo ROOT_URL;?>plugins/highlight/highlight.pack.js"></script>
    <script src="<?php echo ROOT_URL;?>assets/js/custom.js"></script>
    <!-- END GLOBAL MANDATORY SCRIPTS -->

    <!-- BEGIN PAGE LEVEL SCRIPTS -->
	 <script src="<?php echo ROOT_URL;?>assets/js/scrollspyNav.js"></script>
    <script src="<?php echo ROOT_URL;?>plugins/table/datatable/datatables.js"></script>
    <script>
        $(document).ready(function() {
            $('table.multi-table').DataTable({
                "dom": "<'dt--top-section'<'row'<'col-12 col-sm-6 d-flex justify-content-sm-start justify-content-center'l><'col-12 col-sm-6 d-flex justify-content-sm-end justify-content-center mt-sm-0 mt-3'f>>>" +
        "<'table-responsive'tr>" +
        "<'dt--bottom-section d-sm-flex justify-content-sm-between text-center'<'dt--pages-count  mb-sm-0 mb-3'i><'dt--pagination'p>>",
                "oLanguage": {
                    "oPaginate": { "sPrevious": '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-arrow-left"><line x1="19" y1="12" x2="5" y2="12"></line><polyline points="12 19 5 12 12 5"></polyline></svg>', "sNext": '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-arrow-right"><line x1="5" y1="12" x2="19" y2="12"></line><polyline points="12 5 19 12 12 19"></polyline></svg>' },
                    "sInfo": "Showing page _PAGE_ of _PAGES_",
                    "sSearch": '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-search"><circle cx="11" cy="11" r="8"></circle><line x1="21" y1="21" x2="16.65" y2="16.65"></line></svg>',
                    "sSearchPlaceholder": "Search...",
                   "sLengthMenu": "Results :  _MENU_",
                },
                "stripeClasses": [],
                "lengthMenu": [7, 10, 20, 50],
                "pageLength": 7,
                drawCallback: function () {
                    $('.t-dot').tooltip({ template: '<div class="tooltip status" role="tooltip"><div class="arrow"></div><div class="tooltip-inner"></div></div>' })
                    $('.dataTables_wrapper table').removeClass('table-striped');
                }
            });
        } );
    </script>
	<script src="<?php echo ROOT_URL;?>assets/js/components/ui-accordions.js"></script>
	<script src="<?php echo ROOT_URL;?>plugins/sweetalerts/sweetalert2.min.js"></script>
    <script src="<?php echo ROOT_URL;?>plugins/sweetalerts/custom-sweetalert.js"></script>
	<script src="<?php echo ROOT_URL;?>plugins/file-upload/file-upload-with-preview.min.js"></script>
    <!-- END PAGE LEVEL SCRIPTS -->

</body>
</html>
<script>

$(document).ready(function(){
  $("button").click(function(){
    $("p").slideToggle();
  });
});

function FormNewPacket(mode) {
	if(mode=='open') {
		$('#mdlNewPacket').modal({backdrop: 'static',keyboard: false});
		document.all('packetactive').disabled=true;
		document.getElementById('edittrainee').value='';
	} else {
		$('#mdlNewPacket').modal('hide');	
	}
}

function formatRupiah(angka, prefix) {
    var number_string = angka.replace(/[^,\d]/g, '').toString(),
		split = number_string.split(','),
        sisa  = split[0].length % 3,
        rupiah = split[0].substr(0, sisa),
        ribuan = split[0].substr(sisa).match(/\d{3}/gi);
            
	if (ribuan) {
		separator = sisa ? '.' : '';
        rupiah += separator + ribuan.join('.');
	}
        
    rupiah = split[1] != undefined ? rupiah + ',' + split[1] : rupiah;
    return prefix == undefined ? rupiah : (rupiah ? 'Rp. ' + rupiah : '');
}

var tanpa_rupiah = document.getElementById('packetprice');
    tanpa_rupiah.addEventListener('keyup', function(e)
    {
        tanpa_rupiah.value = formatRupiah(this.value);
    });
	
$('#mdlNewPacket').on('hidden.bs.modal', function () {
  $(this).find('#frmRegistration')[0].reset(); 
})

$('#frmRegistration').submit(function (e) {
	e.preventDefault();
	var formData = new FormData(this);
	  $.ajax({
		url: "../../actions/trainee_registration.php",
		type: "POST",
		data: formData,
		success: function (msg) {
		  if(msg=='success') {
				const toast = swal.mixin({
					toast: true,
					position: 'top-end',
					showConfirmButton: false,
					timer: 2000,
					padding: '2em'
				  });

				  toast({
					type: 'success',
					title: 'Data Tersimpan !\n<span style="color:red;font-size:12px;">Data akan reload dalam waktu 2 detik</span>',
					padding: '2em',
				  })
				  FormNewPacket('close');
				  setTimeout(function(){
					   window.location.reload();
				}, 2000);
		  } else {
			  const toast = swal.mixin({
					toast: true,
					position: 'top-end',
					showConfirmButton: false,
					timer: 2000,
					padding: '2em'
				  });

				  toast({
					type: 'error',
					title: 'Gagal menyimpan data !',
					padding: '2em',
				  })
		  }
		},
		cache: false,
		contentType: false,
		processData: false
	  });
});

function ShowDataTrainee(code) {
	fetch('trainee_view.php?code='+code)
	.then(response=>response.json())
		.then(responseJson=>{
			if(responseJson[0].packet_name!='') {
				$('#mdlNewPacket').modal({backdrop: 'static',keyboard: false});	
				document.getElementById('edittrainee').value=code;
				document.getElementById('packetname').value=responseJson[0].packet_name;
				document.getElementById('packetduration').value=responseJson[0].packet_session;
				document.getElementById('packetprice').value=responseJson[0].packet_price.toLocaleString('en-US');
				document.getElementById('packetactive').value=responseJson[0].packet_active;
				document.all('packetactive').disabled=null;
			}
	});
}
</script>
<?php
include '../../includes/connection_close.inc';
?>