<?php
include '../../includes/connection.inc';
include '../../query/maxim.sql';
include '../../includes/header.inc';
?>

    <!-- BEGIN PAGE LEVEL PLUGINS/CUSTOM STYLES -->
    <link rel="stylesheet" type="text/css" href="<?php echo ROOT_URL;?>assets/css/forms/theme-checkbox-radio.css">
    <link href="<?php echo ROOT_URL;?>assets/css/scrollspyNav.css" rel="stylesheet" type="text/css" />
    <link href="<?php echo ROOT_URL;?>assets/css/components/custom-media_object.css" rel="stylesheet" type="text/css" />
	<link href="<?php echo ROOT_URL;?>assets/css/components/custom-modal.css" rel="stylesheet" type="text/css" />
	<link href="<?php echo ROOT_URL;?>plugins/animate/animate.css" rel="stylesheet" type="text/css" />
    <script src="<?php echo ROOT_URL;?>plugins/sweetalerts/promise-polyfill.js"></script>
    <link href="<?php echo ROOT_URL;?>plugins/sweetalerts/sweetalert2.min.css" rel="stylesheet" type="text/css" />
    <link href="<?php echo ROOT_URL;?>plugins/sweetalerts/sweetalert.css" rel="stylesheet" type="text/css" />
    <link href="<?php echo ROOT_URL;?>assets/css/components/custom-sweetalert.css" rel="stylesheet" type="text/css" />
    <!-- END PAGE LEVEL PLUGINS/CUSTOM STYLES -->        
</head>
<?php
$arrayUid = explode('|',$_SESSION['MAXIM_AUTH']);
CheckUserAccessCurrentMenuPage($conn,$arrayUid[1],'MNU006');
?>
<body class="sidebar-noneoverflow" data-spy="scroll" data-target="#navSection" data-offset="100">
    
    <!--  BEGIN NAVBAR  -->
    <?php include '../../includes/navbar.inc';?>
    <!--  END NAVBAR  -->

    <!--  BEGIN MAIN CONTAINER  -->
    <div class="main-container" id="container">

        <div class="overlay"></div>
        <div class="cs-overlay"></div>
        <div class="search-overlay"></div>

        <!--  BEGIN SIDEBAR  -->
        <?php include '../../includes/sidebar.inc';?>
        <!--  END SIDEBAR  -->

        <!--  BEGIN CONTENT AREA  -->
        <div id="content" class="main-content">
			<div class="layout-px-spacing">
                <div class="row layout-top-spacing" id="cancel-row">
                    <div class="col-xl-12 col-lg-12 col-sm-12  layout-spacing">
						<div class="row">
							<div class="col"><h3 style="color:<?php echo BASE_COLOR;?>;">Transaksi Toko </h3></div>
							<div class="col text-right"><button title="cari customer/member" class="btn btn-dark mb-2 mr-2 rounded-circle" onclick="FormShop('open');"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-search"><circle cx="11" cy="11" r="8"></circle><line x1="21" y1="21" x2="16.65" y2="16.65"></line></svg></button></div>
						</div>
                        <div class="widget-content widget-content-area br-6">
								<div class="widget-content widget-content-area">
                                    <div class="media">
                                        <div class="media-body">
                                            <h4 class="media-heading">Informasi Customer/Member</h4>
                                            <p class="media-text text-black">
												<b style="color:<?php echo BASE_COLOR;?>;">Nama Member</b><br>
												<span name="dvMemberName" id="dvMemberName"></span><br>
												<b style="color:<?php echo BASE_COLOR;?>;">Gate / Member ID</b><br>
												<span name="dvGateUID" id="dvGateUID"></span>
                                            </p>
                                        </div>
                                        <img name="memberphoto" id="memberphoto" style="display:none;" class="rounded" src="<?php echo ROOT_URL;?>assets/img/memberphoto/profile-4.jpg" alt="pic1">
                                    </div>
								</div>
                        </div>
						
						<div class="widget-content widget-content-area br-4" style="margin-top:10px;pointer-events:none;" name="dvItem" id="dvItem">
								<div class="widget-content widget-content-area">
                                    <div class="media">
                                        <div class="media-body">
											<div class="row">
												<div class="col-8">
												<p class="media-text text-black">
													<form method="post" name="frmShopping" id="frmShopping">
														<input type="hidden" name="muid" id="muid">
														<div class="form-row mb-2">
															<div class="col">
															  <select type="text" class="form-control" id="cat" name="cat" required onchange="RefreshItemByCategory(this.value);" style="width:220px;">
																<option value="" selected disabled>Kategori</option>
																<?php
																$arrayItem=ItemCategory($conn,'');
																$jsonItem=json_decode($arrayItem);
																foreach($jsonItem as $jsonitem) {
																	echo '<option value="'.$jsonitem->category_code.'">'.$jsonitem->category_name.'</option>';
																}
																?>
															  </select>
															</div>
															<div class="col">
															  <select type="text" class="form-control" required id="item" name="item" style="width:220px;">
																<option value="" selected disabled>Nama Item</option>
															  </select>
															</div>
															<div class="col">
															  <input type="number" style="width:100px;" class="form-control" required min="1" max="100" value="1" id="qty" name="qty">
															</div>
														</div>
														<br>
														<button type="submit" class="mb-4 btn btn-primary"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-shopping-cart"><circle cx="9" cy="21" r="1"></circle><circle cx="20" cy="21" r="1"></circle><path d="M1 1h4l2.68 13.39a2 2 0 0 0 2 1.61h9.72a2 2 0 0 0 2-1.61L23 6H6"></path></svg>&nbsp;Tambahkan</button>
													</form>
												</p>
												</div>
												<div class="col-4">
												<h4 class="media-heading">Total Belanja</h4>
												<p class="media-text text-black">
													<h2 name="txtTotalAmount" id="txtTotalAmount">Rp. 0</h2>
												</p>
												</div>
											</div>
                                        <img name="memberphoto" id="memberphoto" style="display:none;" class="rounded" src="<?php echo ROOT_URL;?>assets/img/memberphoto/profile-4.jpg" alt="pic1">
                                    </div>

								</div>
                        </div>
						
						<!-- ShoppingCart -->
						<div class="widget-content widget-content-area br-4">
								<div class="widget-content widget-content-area">
                                    <div class="media">
                                        <div class="media-body" id="dvShopList" name="dvShopList">
											<table class="table table-bordered table-hover table-striped mb-4" style="margin-top:-70px;">
												<thead>
													<tr>
														<th>Tanggal</th>
														<th>Nama Item</th>
														<th>Harga</th>
														<th>Qty</th>
														<th class="text-center">Total</th>
														<th></th>
													</tr>
												</thead>
												<tbody>
													<tr >
														<td style="color:black;" colspan="6" class="text-center text-black">Transaksi Belum Ada</td>
													</tr>
												</tbody>
											</table>
                                        </div>
                                    </div>
								</div>
                        </div>
						
						
                    </div>
				</div>
            </div>
        <?php include '../../includes/footer.inc';?>
        </div>
        <!--  END CONTENT AREA  -->


    </div>
    <!-- END MAIN CONTAINER -->
	
	<!-- Modal -->
	<div id="mdlShop" class="modal fade bd-example-modal-sm" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel" aria-hidden="true">
		<div class="modal-dialog modal-lg	" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title" id="mySmallModalLabel">Customer/Member</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <svg aria-hidden="true" xmlns="http://www.w3.org/2000/svg" style="color:red;" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-x"><line x1="18" y1="6" x2="6" y2="18"></line><line x1="6" y1="6" x2="18" y2="18"></line></svg>
                    </button>
                </div>
                <div class="modal-body">
					<p class="modal-text">
							<div class="form-row mb-4">
								<div class="form-group col-md-8">
									<input placeholder="Member Name/No. Gate/Member Id" type="text" class="form-control text-uppercase" name="gateuid" id="gateuid" required>
								</div>
								<div class="form-group col-md-4">
									<button id="btnFindMember" name="btnFindMember" class="btn btn-sm btn-dark" title="cari data"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-search"><circle cx="11" cy="11" r="8"></circle><line x1="21" y1="21" x2="16.65" y2="16.65"></line></svg></button>
								</div>
								<div class="form-group col-md-12" name="dvFind" id="dvFind">
									
								</div>
								
							</div>
						
					</p>
                </div>
                <div class="modal-footer">
					<button class="btn" data-dismiss="modal"><i class="flaticon-cancel-12"></i> Batal</button>
                </div>
				
            </div>
        </div>
    </div>
	<!-- End of Modal -->

    <!-- BEGIN GLOBAL MANDATORY SCRIPTS -->
    <script src="<?php echo ROOT_URL;?>assets/js/libs/jquery-3.1.1.min.js"></script>
    <script src="<?php echo ROOT_URL;?>bootstrap/js/popper.min.js"></script>
    <script src="<?php echo ROOT_URL;?>bootstrap/js/bootstrap.min.js"></script>
    <script src="<?php echo ROOT_URL;?>plugins/perfect-scrollbar/perfect-scrollbar.min.js"></script>
    <script src="<?php echo ROOT_URL;?>plugins/blockui/jquery.blockUI.min.js"></script>
    <script src="<?php echo ROOT_URL;?>assets/js/app.js"></script>
	<script src="<?php echo ROOT_URL;?>plugins/sweetalerts/sweetalert2.min.js"></script>
    <script src="<?php echo ROOT_URL;?>plugins/sweetalerts/custom-sweetalert.js"></script>
    
    <script>
        $(document).ready(function() {
            App.init();
        });
    </script>
    <script src="<?php echo ROOT_URL;?>plugins/highlight/highlight.pack.js"></script>
    <script src="<?php echo ROOT_URL;?>assets/js/custom.js"></script>
    <!-- END GLOBAL MANDATORY SCRIPTS -->
    <script src="<?php echo ROOT_URL;?>assets/js/scrollspyNav.js"></script>
</body>

</html>
<script>
function FormShop(mode) {
	if(mode=='open') {
		$('#mdlShop').modal({backdrop: 'static',keyboard: false});
		
	} else {
		$('#mdlShop').modal('hide');	
	}
}

$('#mdlShop').on('hidden.bs.modal', function () {
  $(this).find('#frmFindMember')[0].reset(); 
})

function ShowCart(muid) {
	var xmlhttp = new XMLHttpRequest();
	xmlhttp.onreadystatechange = function() {
		var tValue;
		if (this.readyState == 4 && this.status == 200) {
			tValue=JSON.parse(this.responseText);
			if(tValue==null) {
				const toast = swal.mixin({
					toast: true,
					position: 'top-end',
					showConfirmButton: false,
					timer: 2000,
					padding: '2em'
				  });

				  toast({
					type: 'error',
					title: 'Data Gate / Member tidak ditemukan !',
					padding: '2em',
				  })
				document.getElementById('memberphoto').style.display='none';
				document.getElementById('dvGateUID').innerHTML='';
				document.getElementById('dvMemberName').innerHTML='';
				document.all('dvItem').style.pointerEvents='none';
				document.getElementById('muid').value='';
				document.getElementById('gateuid').value='';
				document.getElementById('gateuid').focus();
			} else {
				document.all('dvItem').style.pointerEvents='';
				document.getElementById('memberphoto').src='<?php echo ROOT_URL;?>assets/img/memberphoto/'+JSON.parse(this.responseText)[0].member_photo;
				document.getElementById('memberphoto').style.display='';
				document.getElementById('dvGateUID').innerHTML=JSON.parse(this.responseText)[0].member_cardnumber+' / '+JSON.parse(this.responseText)[0].member_uid;
				document.getElementById('dvMemberName').innerHTML=JSON.parse(this.responseText)[0].member_fullname;
				document.getElementById('muid').value=JSON.parse(this.responseText)[0].member_uid;
				
				fetch('members_currentcart.php?muid='+JSON.parse(this.responseText)[0].member_uid)
				.then(response=>response.text())
				.then(responseText=>{
					var tArrayShopList=responseText.split('|');
					document.getElementById('dvShopList').innerHTML=tArrayShopList[0];
					document.getElementById('txtTotalAmount').innerHTML='Rp. '+tArrayShopList[1];
				});
				
				FormShop('close');
			}
			
		}
	};
	xmlhttp.open("GET","members_findbyid.php?gateuid="+muid,true);
	xmlhttp.send();
}

$('#btnFind').click(function(event) {
	event.preventDefault();
	var tGateUid=document.getElementById('gateuid').value;
	
});

function RefreshItemByCategory(cat) {
	var xmlhttp = new XMLHttpRequest();
	xmlhttp.onreadystatechange = function() {
	var tValue;
	if (this.readyState == 4 && this.status == 200) {
		tValue=JSON.parse(this.responseText);
		$("#item").empty();
		if(tValue==null) {
		} else {
				document.all('dvItem').style.pointerEvents='';
				var selectList=document.getElementById('item');
				var option = document.createElement("option");
				option.value = '';
				option.text = 'Nama Item';
				option.disabled=true;
				selectList.appendChild(option);
				selectList.getElementsByTagName('option')[0].selected = 'selected';
				
			for(var i=0;i<JSON.parse(this.responseText).length;i++) {
				var option = document.createElement("option");
				option.value = JSON.parse(this.responseText)[i].item_code;
				option.text = JSON.parse(this.responseText)[i].item_name;
				selectList.appendChild(option);
			}
			
			//document.getElementById('dvPostal').innerHTML=this.responseText;
		}
	}
	};
	xmlhttp.open("GET","../../apis/itemstore_by_category.php?cat="+cat,true);
	xmlhttp.send();
}

$('#frmShopping').submit(function(e) {
	event.preventDefault();
	var formData = new FormData(this);
	  $.ajax({
		url: "../../actions/addToCart.php",
		type: "POST",
		data: formData,
		success: function (msg) {
			var tArrayMsg=msg.split('|');
		  if(tArrayMsg[1]!='failed') {
				document.getElementById('txtTotalAmount').innerHTML='Rp. '+tArrayMsg[1];
				document.getElementById('dvShopList').innerHTML=tArrayMsg[0];
				$('#frmShopping')[0].reset();
				$('#frmShopping')[1].reset();
				$('#frmShopping')[2].reset();
				const toast = swal.mixin({
					toast: true,
					position: 'top-end',
					showConfirmButton: false,
					timer: 2000,
					padding: '2em'
				  });

				  toast({
					type: 'success',
					title: 'Data Tersimpan di Keranjang!',
					padding: '2em',
				  })
				  FormRegistration('close');
				  setTimeout(function(){
					   window.location.reload();
				}, 2000);
				
		  } else {
			  const toast = swal.mixin({
					toast: true,
					position: 'top-end',
					showConfirmButton: false,
					timer: 2000,
					padding: '2em'
				  });

				  toast({
					type: 'error',
					title: 'Gagal menyimpan data !',
					padding: '2em',
				  })
		  }
		},
		cache: false,
		contentType: false,
		processData: false
	  });
});

function RemoveTransaction(muid,trxcode) {
	if(confirm('Hapus Transaksi ?')) {
		fetch('members_currentcart.php?muid='+muid+'&did='+trxcode)
		.then(response=>response.text())
		.then(responseText=>{
			var tArrayShopList=responseText.split('|');
			document.getElementById('dvShopList').innerHTML=tArrayShopList[0];
			document.getElementById('txtTotalAmount').innerHTML='Rp. '+tArrayShopList[1];
		});
	}
}

$('#btnFindMember').click(function(e) {
	if(document.getElementById('gateuid').value!='') {
		fetch('members_findBymulti.php?find='+document.getElementById('gateuid').value)
		.then(responseJson=>responseJson.text())
		.then(response=>{
			document.getElementById('dvFind').innerHTML=response;
		});
	}
});

$('#mdlShop').on('hidden.bs.modal', function () {
  document.getElementById('gateuid').value='';
})



</script>
<?php include '../../includes/connection_close.inc';?>