<?php
include '../../includes/connection.inc';
include '../../query/maxim.sql';
include '../../includes/header.inc';
?>
    
    
    <!-- BEGIN PAGE LEVEL STYLES -->
    <link rel="stylesheet" type="text/css" href="<?php echo ROOT_URL;?>plugins/table/datatable/datatables.css">
    <link rel="stylesheet" type="text/css" href="<?php echo ROOT_URL;?>plugins/table/datatable/dt-global_style.css">
    <link rel="stylesheet" type="text/css" href="<?php echo ROOT_URL;?>plugins/table/datatable/custom_dt_multiple_tables.css">
	<link href="<?php echo ROOT_URL;?>plugins/animate/animate.css" rel="stylesheet" type="text/css" />
	<link href="<?php echo ROOT_URL;?>assets/css/scrollspyNav.css" rel="stylesheet" type="text/css" />
    <link href="<?php echo ROOT_URL;?>assets/css/components/custom-modal.css" rel="stylesheet" type="text/css" />
	<link rel="stylesheet" type="text/css" href="<?php echo ROOT_URL;?>assets/css/forms/switches.css">
	<link href="<?php echo ROOT_URL;?>assets/css/components/tabs-accordian/custom-accordions.css" rel="stylesheet" type="text/css" />
    <!-- END PAGE LEVEL STYLES -->
	
	<!-- BEGIN THEME GLOBAL STYLES -->
    <link href="<?php echo ROOT_URL;?>assets/css/scrollspyNav.css" rel="stylesheet" type="text/css" />
    <link href="<?php echo ROOT_URL;?>plugins/animate/animate.css" rel="stylesheet" type="text/css" />
    <script src="<?php echo ROOT_URL;?>plugins/sweetalerts/promise-polyfill.js"></script>
    <link href="<?php echo ROOT_URL;?>plugins/sweetalerts/sweetalert2.min.css" rel="stylesheet" type="text/css" />
    <link href="<?php echo ROOT_URL;?>plugins/sweetalerts/sweetalert.css" rel="stylesheet" type="text/css" />
    <link href="<?php echo ROOT_URL;?>assets/css/components/custom-sweetalert.css" rel="stylesheet" type="text/css" />
	<link href="<?php echo ROOT_URL;?>plugins/file-upload/file-upload-with-preview.min.css" rel="stylesheet" type="text/css" />
</head>
<?php
$arrayUid = explode('|',$_SESSION['MAXIM_AUTH']);
CheckUserAccessCurrentMenuPage($conn,$arrayUid[1],'MNU002');
?>
<body class="sidebar-noneoverflow">
    <!-- BEGIN LOADER -->
    <div id="load_screen"> <div class="loader"> <div class="loader-content">
        <div class="spinner-grow align-self-center"></div>
    </div></div></div>
    <!--  END LOADER -->
    
    <!--  BEGIN NAVBAR  -->
    <?php include '../../includes/navbar.inc';?>
    <!--  END NAVBAR  -->

    <!--  BEGIN MAIN CONTAINER  -->
    <div class="main-container" id="container">

        <div class="overlay"></div>
        <div class="cs-overlay"></div>
        <div class="search-overlay"></div>

        <!--  BEGIN SIDEBAR  -->
        <?php include '../../includes/sidebar.inc';?>
        <!--  END SIDEBAR  -->

        <!--  BEGIN CONTENT AREA  -->
        <div id="content" class="main-content">
            <div class="layout-px-spacing">
                
                <div class="row layout-top-spacing" id="cancel-row">
					<?php
					$fullname=GetFieldFromMember($conn,'member_fullname',encrypt_decrypt('decrypt',$_REQUEST['m']));
					?>
                    <div class="col-xl-12 col-lg-12 col-sm-12  layout-spacing">
						<div class="row">
							<div class="col"><h3 style="color:<?php echo BASE_COLOR;?>;">Paket Trainee&nbsp;<span style="font-size:20px;" class="text-black"><?php echo encrypt_decrypt('decrypt',$_REQUEST['m']);?></span></h3></div>
							<div class="col text-right"><button title="registrasi" class="btn btn-dark mb-2 mr-2 rounded-circle" onclick="FormTrainee('open');"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-plus"><line x1="12" y1="5" x2="12" y2="19"></line><line x1="5" y1="12" x2="19" y2="12"></line></svg></button></div>
						</div>
                        <div class="widget-content widget-content-area br-6">
							<div class="table-responsive">	
                            <table class="multi-table table table-striped table-bordered table-hover non-hover" style="width:100%">
                                <thead>
                                    <tr>
										<th>Pembayaran</th>
										<th>Kode Member</th>
										<th>Nama Lengkap</th>
										<th>Tipe</th>
										<th>Periode</th>
										<th>Mulai</th>
                                        <th>Trainee</th>
										<th>Sesi</th>
										<th>Expire</th>
										<th>Nama Trainer</th>
										<th>Status</th>
                                        <th class="text-center dt-no-sorting">&nbsp;</th>
                                    </tr>
                                </thead>
                                <tbody>
									<?php
									$muid=encrypt_decrypt('decrypt',$_REQUEST['m']);
									$expire=date('Y-m-d',strtotime(GetFieldFromMember($conn,'member_expire',$muid)));
									$arrayTrainee=MemberTraineeByMuid($conn,$muid);
									$jsonTrainee=json_decode($arrayTrainee);
									foreach($jsonTrainee as $jsontrainee) {
										$fullname=GetFieldFromMember($conn,'member_fullname',$muid);
										$memberType=GetFieldFromMember($conn,'member_type',$muid);
										$memberTypeName=MemberTypeTitleById($conn,$memberType);
										$expire=date('Y-m-d',strtotime(GetFieldFromMember($conn,'member_expire',$muid)));
										$period=GetFieldFromMember($conn,'member_period',$muid);
										$trainee_name=GetFieldFromTraineeByCode($conn,'packet_name',$jsontrainee->trainee_code);
										$duration=$jsontrainee->trainee_duration;
										$start=date('d-m-Y',strtotime($jsontrainee->trainee_start));
										$trainerName=GetFieldFromTrainerByCode($conn,'trainer_fullname',$jsontrainee->trainer_code);
										if($jsontrainee->trx_paid==null || $jsontrainee->trx_paid=='') {
											$lunas='<span class="badge badge-danger">Belum Lunas';
										} else {
											$lunas='<span class="badge badge-success">Lunas';
										}
										if($jsontrainee->member_expire<date('Y-m-d')) {
											$status='<span class="badge badge-danger">Selesai';
										} else {
											$status='<span class="badge badge-info">Aktif';
										}
									?>
									<tr>
										<td class="text-center text-black"><?php echo $lunas;?></td>
										<td class="text-center text-black"><?php echo $muid;?></td>
										<td><b class="text-primary"><?php echo $fullname;?></b></td>
                                        <td class="text-black"><?php echo $memberTypeName;?></td>
                                        <td class="text-black"><?php echo $period;?> Bulan</td>
										<td class="text-black"><?php echo $start;?></td>
										<td class="text-black"><?php echo $trainee_name;?></td>
										<td class="text-black"><?php echo $duration;?></td>
										<td class="text-black"><?php echo $expire;?></td>
                                        <td class="text-black"><?php echo $trainerName;?></td>
										<td class="text-black"><?php echo $status;?></td>
										<td class="text-black;text-right">
											<?php
											if($jsontrainee->trx_paid==null || $jsontrainee->trx_paid=='') {
											?>
											<button title="Edit" onclick="ViewTrainee('<?php echo $jsontrainee->trx_code;?>')" class="btn btn-warning mb-2 mr-2 rounded-circle"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-edit-3"><path d="M12 20h9"></path><path d="M16.5 3.5a2.121 2.121 0 0 1 3 3L7 19l-4 1 1-4L16.5 3.5z"></path></svg></button>
											<?php
											} else {
												echo '&nbsp;';
											}
											?>
										</td>
                                    </tr>
									<?php
									}
									?>
                                </tbody>
                                <tfoot>
									<tr>
										<th>Pembayaran</th>
										<th>Kode Member</th>
										<th>Nama Lengkap</th>
										<th>Tipe</th>
										<th>Periode</th>
										<th>Mulai</th>
                                        <th>Trainee</th>
										<th>Sesi</th>
										<th>Expire</th>
										<th>Nama Trainer</th>
										<th>Status</th>
                                        <th class="text-center dt-no-sorting">&nbsp;</th>
                                    </tr>
                                </tfoot>
                            </table>
							</div>
                        </div>
                    </div>
		        </div>

                </div>
        <?php include '../../includes/footer.inc';?>		
        </div>
        <!--  END CONTENT AREA  -->

    </div>
    <!-- END MAIN CONTAINER -->
    
	<!-- Modal -->
	<div id="mdlFrmTrainee" class="modal animated rotateInDownLeft custo-rotateInDownLeft" role="dialog">
		<div class="modal-dialog  modal-xl">
			<!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header" style="background-color:<?php echo BASE_COLOR;?>;">
					<h5 class="modal-title" style="color:white;">PAKET TRAINEE</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <svg style="color:white;" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-x"><line x1="18" y1="6" x2="6" y2="18"></line><line x1="6" y1="6" x2="18" y2="18"></line></svg>
                    </button>
                </div>
                <div class="modal-body">
					<p class="modal-text">
						<div class="row">
							<div class="col-sm-8">
								<form name="frmMemberTransaction" id="frmMemberTransaction" method="post">
									<input type="hidden" name="editcode" id="editcode">
									<input type="hidden" name="muid" id="muid" value="<?php echo $muid;?>">
									<input type="date" name="expire" id="expire" value="<?php echo $expire;?>" style="display:none;">
									<div class="form-row mb-4">
										<div class="form-group col-md-6">
											<label for="inputEmail4">Nama Member</label>
                                            <input type="text" style="margin-left:-20px;color:<?php echo BASE_COLOR;?>;font-weight:bold;pointer-events:none;border:1px solid white;background-color:white;" class="form-control" id="membername" name="membername" value="<?php echo $fullname;?>">
                                        </div>
                                        <div class="form-group col-md-6">
											<label for="inputPassword4">Member ID</label>
                                            <input type="text" style="margin-left:-20px;color:<?php echo BASE_COLOR;?>;font-weight:bold;pointer-events:none;border:1px solid white;background-color:white;"  class="form-control" id="memberuid" name="memberuid" value="<?php echo encrypt_decrypt('decrypt',$_REQUEST['m']);?>">
                                        </div>
									</div>
									<div class="form-row mb-4">
										<div class="form-group col-md-4">
											<label for="inputEmail4">Tipe Paket</label>
                                            <select class="form-control text-black" id="packetname" name="packetname" required>
												<option value="" selected disabled></option>
												<?php
												$arrayPacket=PacketTrainee($conn,'','');
												$jsonPacket=json_decode($arrayPacket);
												foreach($jsonPacket as $jsonpacket) {
													echo '<option value="'.$jsonpacket->packet_code.'|'.number_format($jsonpacket->packet_price).'|'.$jsonpacket->packet_session.'">'.$jsonpacket->packet_name.'</option>';
												}
												?>
											</select>
                                        </div>
                                        <div class="form-group col-md-4">
											<label for="inputPassword4">Harga (Rp)</label>
                                            <input type="text" readonly class="form-control text-black text-right" id="packetprice" name="packetprice">
                                        </div>
										<div class="form-group col-md-4">
											<label for="inputEmail4">Jumlah Sesi</label>
                                            <input type="text" readonly style="text-align:right;" class="form-control text-black" id="packetsession" name="packetsession">
                                        </div>
									</div>
									<div class="form-row mb-4">
										<div class="form-group col-md-4">
											<label for="inputPassword4">Tgl Mulai</label>
                                            <input type="date" class="form-control" name="packetstart" id="packetstart" required value="<?php echo date('Y-m-d');?>">
                                        </div>
										<div class="form-group col-md-8">
											<label for="inputPassword4">Nama Trainer</label>
                                            <select class="form-control text-black text-capitalize" name="trainername" id="trainername" required>
												<option value="" selected disabled></option>
												<?php
												$arrayTrainer=TrainerActive($conn,'');
												$jsonTrainer=json_decode($arrayTrainer);
												foreach($jsonTrainer as $jsontrainer) {
													echo '<option value="'.$jsontrainer->trainer_uid.'">'.$jsontrainer->trainer_fullname.'</option>';
												}
												?>
											</select>
                                        </div>
									</div>
									<div class="form-row mb-4">
										<div class="form-group col-md-12">
											<label for="inputPassword4">Catatan</label>
                                            <textarea class="form-control" name="packetnote" id="packetnote" rows="3"></textarea>
                                        </div>
									</div>
									    <div class="form-group row">
                                            <div class="col-sm-10">
                                                <button type="submit" class="btn btn-primary mt-3"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-shopping-cart"><circle cx="9" cy="21" r="1"></circle><circle cx="20" cy="21" r="1"></circle><path d="M1 1h4l2.68 13.39a2 2 0 0 0 2 1.61h9.72a2 2 0 0 0 2-1.61L23 6H6"></path></svg>&nbsp;&nbsp;Simpan Ke Transaksi</button>
                                            </div>
                                        </div>
                                </form>
							</div>
							<div class="col-sm-4">
								<div name="dvDetailPayment" id="dvDetailPayment">
									<h4 style="color:<?php echo BASE_COLOR;?>">Tipe Member</h4>
									<div class="table-responsive">
										<table class="table table-bordered mb-4">
												<?php
												$memberTypeName=MemberTypeTitleById($conn,GetFieldFromMember($conn,'member_type',encrypt_decrypt('decrypt',$_REQUEST['m'])));
												$memberTypePeriod=GetFieldFromMember($conn,'member_period',encrypt_decrypt('decrypt',$_REQUEST['m']));
												$memberExpired=GetFieldFromMember($conn,'member_expire',encrypt_decrypt('decrypt',$_REQUEST['m']));
												?>
											<tr style="background-color:#f3e5f5;font-weight:bold;">
												<td style="color:<?php echo BASE_COLOR;?>;">Tipe</td>
												<td><?php echo $memberTypeName;?></td>
											</tr>
											<tr style="background-color:#f3e5f5;font-weight:bold;">
												<td style="color:<?php echo BASE_COLOR;?>;">Periode</td>
												<td><?php echo $memberTypePeriod;?>&nbsp;bulan</td>
											</tr>
											<tr style="background-color:#f3e5f5;font-weight:bold;">
												<td style="color:<?php echo BASE_COLOR;?>;">Berlaku Hingga</td>
												<td><?php echo date('d-m-Y',strtotime($memberExpired));?></td>
											</tr>
										</table>
									</div>
								</div>
								<div name="dvDetailPayment" id="dvDetailPayment">
									<h4 style="color:<?php echo BASE_COLOR;?>">Harga</h4>
									<span style="color:blue;font-size:20px;font-weight:bold;" name="lblAmount" id="lblAmount">Rp. 0</span>
								</div>
							</div>
							
						</div>
					</p>
                </div>
            </div>
        </div>
	</div>	
	<!-- End of Modal -->	
    
    <!-- BEGIN GLOBAL MANDATORY SCRIPTS -->
    <script src="<?php echo ROOT_URL;?>assets/js/libs/jquery-3.1.1.min.js"></script>
    <script src="<?php echo ROOT_URL;?>bootstrap/js/popper.min.js"></script>
    <script src="<?php echo ROOT_URL;?>bootstrap/js/bootstrap.min.js"></script>
    <script src="<?php echo ROOT_URL;?>plugins/perfect-scrollbar/perfect-scrollbar.min.js"></script>
	<script src="<?php echo ROOT_URL;?>plugins/blockui/jquery.blockUI.min.js"></script>
    <script src="<?php echo ROOT_URL;?>assets/js/app.js"></script>
    
    <script>
        $(document).ready(function() {
            App.init();
        });
    </script>
	<script src="<?php echo ROOT_URL;?>plugins/highlight/highlight.pack.js"></script>
    <script src="<?php echo ROOT_URL;?>assets/js/custom.js"></script>
    <!-- END GLOBAL MANDATORY SCRIPTS -->

    <!-- BEGIN PAGE LEVEL SCRIPTS -->
	 <script src="<?php echo ROOT_URL;?>assets/js/scrollspyNav.js"></script>
    <script src="<?php echo ROOT_URL;?>plugins/table/datatable/datatables.js"></script>
    <script>
        $(document).ready(function() {
            $('table.multi-table').DataTable({
                "dom": "<'dt--top-section'<'row'<'col-12 col-sm-6 d-flex justify-content-sm-start justify-content-center'l><'col-12 col-sm-6 d-flex justify-content-sm-end justify-content-center mt-sm-0 mt-3'f>>>" +
        "<'table-responsive'tr>" +
        "<'dt--bottom-section d-sm-flex justify-content-sm-between text-center'<'dt--pages-count  mb-sm-0 mb-3'i><'dt--pagination'p>>",
                "oLanguage": {
                    "oPaginate": { "sPrevious": '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-arrow-left"><line x1="19" y1="12" x2="5" y2="12"></line><polyline points="12 19 5 12 12 5"></polyline></svg>', "sNext": '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-arrow-right"><line x1="5" y1="12" x2="19" y2="12"></line><polyline points="12 5 19 12 12 19"></polyline></svg>' },
                    "sInfo": "Showing page _PAGE_ of _PAGES_",
                    "sSearch": '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-search"><circle cx="11" cy="11" r="8"></circle><line x1="21" y1="21" x2="16.65" y2="16.65"></line></svg>',
                    "sSearchPlaceholder": "Search...",
                   "sLengthMenu": "Results :  _MENU_",
                },
                "stripeClasses": [],
                "lengthMenu": [7, 10, 20, 50],
                "pageLength": 7,
                drawCallback: function () {
                    $('.t-dot').tooltip({ template: '<div class="tooltip status" role="tooltip"><div class="arrow"></div><div class="tooltip-inner"></div></div>' })
                    $('.dataTables_wrapper table').removeClass('table-striped');
                }
            });
        } );
    </script>
	<script src="<?php echo ROOT_URL;?>assets/js/components/ui-accordions.js"></script>
	<script src="<?php echo ROOT_URL;?>plugins/sweetalerts/sweetalert2.min.js"></script>
    <script src="<?php echo ROOT_URL;?>plugins/sweetalerts/custom-sweetalert.js"></script>
	<script src="<?php echo ROOT_URL;?>plugins/file-upload/file-upload-with-preview.min.js"></script>
    <!-- END PAGE LEVEL SCRIPTS -->

</body>
</html>
<script>

$(document).ready(function(){
	var firstUpload = new FileUploadWithPreview('myFirstImage')
  $("button").click(function(){
    $("p").slideToggle();
  });
});


function FormTrainee(mode) {
	if(mode=='open') {
		$('#mdlFrmTrainee').modal({backdrop: 'static',keyboard: false});
		
	} else {
		$('#mdlFrmTrainee').modal('hide');	
	}

}

function formatRupiah(angka, prefix)
    {
		var number_string = angka.replace(/[^,\d]/g, '').toString(),
            split    = number_string.split(','),
            sisa     = split[0].length % 3,
            rupiah     = split[0].substr(0, sisa),
            ribuan     = split[0].substr(sisa).match(/\d{3}/gi);
            
        if (ribuan) {
            separator = sisa ? '.' : '';
            rupiah += separator + ribuan.join('.');
        }
        
        rupiah = split[1] != undefined ? rupiah + ',' + split[1] : rupiah;
        return prefix == undefined ? rupiah : (rupiah ? 'Rp. ' + rupiah : '');
    }

$('#packetname').change(function (e) {
	var tPacketName=document.getElementById('packetname').value.split('|');
	document.getElementById('packetprice').value=tPacketName[1];
	document.getElementById('lblAmount').innerHTML='Rp. '+tPacketName[1];
	document.getElementById('packetsession').value=tPacketName[2];
});

$('#mdlFrmTrainee').on('hidden.bs.modal', function () {
  $(this).find('#frmMemberTransaction')[0].reset(); 
})

$('#frmMemberTransaction').submit(function(e) {
	e.preventDefault();
	if(document.getElementById('packetstart').value<document.getElementById('expire').value) {
	
			var formData = new FormData(this);
			  $.ajax({
				url: "../../actions/members_trainee_registration.php",
				type: "POST",
				data: formData,
				success: function (msg) {
				  if(msg=='success') {
						const toast = swal.mixin({
							toast: true,
							position: 'top-end',
							showConfirmButton: false,
							timer: 2000,
							padding: '2em'
						  });

						  toast({
							type: 'success',
							title: 'Data Tersimpan !\n<span style="color:red;font-size:12px;">Data akan reload dalam waktu 2 detik</span>',
							padding: '2em',
						  })
						  FormTrainee('close');
						  setTimeout(function(){
							   window.location.reload();
						}, 2000);
				  } else {
					  const toast = swal.mixin({
							toast: true,
							position: 'top-end',
							showConfirmButton: false,
							timer: 2000,
							padding: '2em'
						  });

						  toast({
							type: 'error',
							title: 'Gagal menyimpan data !',
							padding: '2em',
						  })
				  }
				},
				cache: false,
				contentType: false,
				processData: false
			  });
	
	} else {
		const toast = swal.mixin({
		toast: true,
		position: 'top-end',
		showConfirmButton: false,
		timer: 2000,
		padding: '2em'
		});

		toast({
		type: 'error',
		title: 'Tanggal Mulai Melebihi Expire !',
		padding: '2em',
		})
	}
});

function ViewTrainee(code) {
	FormTrainee('open');
	document.getElementById('editcode').value=code;
	var xmlhttp = new XMLHttpRequest();
	xmlhttp.onreadystatechange = function() {
	if (this.readyState == 4 && this.status == 200) {
		document.getElementById('packetname').value=JSON.parse(this.responseText)[0].trainee_code+'|'+formatRupiah(JSON.parse(this.responseText)[0].trainee_price).replace('.',',')+'|'+JSON.parse(this.responseText)[0].trainee_duration;
		document.getElementById('packetprice').value=formatRupiah(JSON.parse(this.responseText)[0].trainee_price).replace('.',',');
		document.getElementById('packetsession').value=JSON.parse(this.responseText)[0].trainee_duration;
		document.getElementById('trainername').value=JSON.parse(this.responseText)[0].trainer_code;
		document.getElementById('packetnote').value=JSON.parse(this.responseText)[0].trainee_note;
	}
	};
	xmlhttp.open("GET","members_viewtrainee.php?trxcode="+code,true);
	xmlhttp.send();
}
</script>
<?php
include '../../includes/connection_close.inc';
?>