<?php
include '../../includes/connection.inc';
include '../../query/maxim.sql';
include '../../includes/header.inc';

$monthName=array('Januari','Februari','Maret','April','Mei','Juni','Juli','Agustus','September','Oktober','November','Desember');
?>
    
    
    <!-- BEGIN PAGE LEVEL STYLES -->
    <link rel="stylesheet" type="text/css" href="<?php echo ROOT_URL;?>plugins/table/datatable/datatables.css">
    <link rel="stylesheet" type="text/css" href="<?php echo ROOT_URL;?>plugins/table/datatable/dt-global_style.css">
	<link href="<?php echo ROOT_URL;?>plugins/animate/animate.css" rel="stylesheet" type="text/css" />
    <script src="<?php echo ROOT_URL;?>plugins/sweetalerts/promise-polyfill.js"></script>
    <link href="<?php echo ROOT_URL;?>plugins/sweetalerts/sweetalert2.min.css" rel="stylesheet" type="text/css" />
    <link href="<?php echo ROOT_URL;?>plugins/sweetalerts/sweetalert.css" rel="stylesheet" type="text/css" />
    <link href="<?php echo ROOT_URL;?>assets/css/components/custom-sweetalert.css" rel="stylesheet" type="text/css" />
	<link href="<?php echo ROOT_URL;?>assets/css/components/custom-modal.css" rel="stylesheet" type="text/css" />
	
    <!-- END PAGE LEVEL STYLES -->
</head>
<?php
$arrayUid = explode('|',$_SESSION['MAXIM_AUTH']);
CheckUserAccessCurrentMenuPage($conn,$arrayUid[1],'MNU016');
?>
<body class="sidebar-noneoverflow">
    <!-- BEGIN LOADER -->
    <div id="load_screen"> <div class="loader"> <div class="loader-content">
        <div class="spinner-grow align-self-center"></div>
    </div></div></div>
    <!--  END LOADER -->
    
    <!--  BEGIN NAVBAR  -->
    <?php include '../../includes/navbar.inc';?>
    <!--  END NAVBAR  -->

    <!--  BEGIN MAIN CONTAINER  -->
    <div class="main-container" id="container">

        <div class="overlay"></div>
        <div class="cs-overlay"></div>
        <div class="search-overlay"></div>

        <!--  BEGIN SIDEBAR  -->
        <?php include '../../includes/sidebar.inc';?>
        <!--  END SIDEBAR  -->

        <?php
		if($_REQUEST['dt1']=='') {
			$dt1=date('Y-m-d');
		} else {
			$dt1=date('Y-m-d',strtotime($_REQUEST['dt1']));
		}
		if($_REQUEST['dt2']=='') {
			$dt2=date('Y-m-d');
		} else {
			$dt2=date('Y-m-d',strtotime($_REQUEST['dt2']));
		}
		?>
		<!--  BEGIN CONTENT AREA  -->
        <div id="content" class="main-content">
            <div class="layout-px-spacing">

                <div class="row layout-top-spacing" id="cancel-row">
                
                    <div class="col-xl-12 col-lg-12 col-sm-12 layout-spacing">
						<div class="row">
							<div class="col"><h3 style="color:<?php echo BASE_COLOR;?>;">Rekap Pendapatan & Pengeluaran</h3></div>
						</div>
                        <div class="widget-content widget-content-area br-6">
							<div class="table-form">
								<div class="form-group row"  style="width:100%;">
									<div class="col-sm-10">
										<form method="get" action="fins_report_baseaccount.php" name="frmSearch" id="frmSearch">
										<div class="form-group row" style="width:55%;">
											<div class="col-sm-4">
												<input type="date" value="<?php echo $dt1;?>" name="dt1" id="dt1" class="form-control form-control-sm" style="background-color:<?php echo BASE_COLOR;?>;color:white;width:150px;" required>
											</div>
											<div class="col-sm-2" style="text-align:center;">
												<label style="margin-left:25px;margin-top:8px;font-weight:bold;color:<?php echo BASE_COLOR;?>">s/d</label>
											</div>
											<div class="col-sm-4">
												<input type="date" value="<?php echo $dt2;?>" name="dt2" id="dt2" class="form-control form-control-sm" style="background-color:<?php echo BASE_COLOR;?>;color:white;width:150px;" required>
											</div>
											<div class="col-sm-2 text-right">
												<button type="submit" style="margin-left:10px;" class="btn btn-warning btn-rounded">Lihat</button>
											</div>
										</div>
										<div class="form-group row" style="width:100%" name="dvDownload" id="dvDownload" style="display:none;">
											<div class="col-sm-12 text-right">
											<img src="<?php echo ROOT_URL;?>assets/img/excel.png" style="width:30px;height:30px;"> <a href="finance_rpt_cashinout.xls" download>Download</a>
											</div>
										</div>
										</form>
									</div>
									<!--
									<div class="col-sm-2 " style="text-align:right">
										<button title="tambah pembukuan" class="btn btn-dark mb-2 rounded-circle" onclick="FormOpen('open');"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-plus"><line x1="12" y1="5" x2="12" y2="19"></line><line x1="5" y1="12" x2="19" y2="12"></line></svg></button>
									</div>
									-->
								</div>
                            </div>
							<div id="dvAccountingTable" name="dvAccountingTable">
							<H4 class="m-4 text-success">Pendapatan</h4>
                            <table id="range-search" class="display table table-hover" style="width:100%">
								<thead>
                                    <tr>
                                        <th class="text-left" style="width:80px;">No.</th>
                                        <th class="text-left" style="width:600px;">Deskripsi</th>
                                        <th class="text-center dt-no-sorting">Nominal (Rp)</th>
                                    </tr>
                                </thead>
								<tbody>
                                	<?php
										$myfile = fopen("finance_rpt_cashinout.xls", "w") or die("Unable to open file!");
										$txt = $txt.'<html><body><h3>Rekap Pendapatan & Pengeluaran<h3><h5>Tanggal '.date('d-m-Y',strtotime($dt1)).' s/d '.date('d-m-Y',strtotime($dt2)).'</h5><br><table border="1"><tr><td style="background-color:#546e7a;color:white;">No.</td><td style="background-color:#546e7a;color:white;">Deskripsi</td><td style="background-color:#546e7a;color:white;>Nominal (Rp)</td></tr>';
										
										$arrayDebet=AccountingByDebet($conn,$dt1,$dt2);
										$jsonDebet=json_decode($arrayDebet);
										$number=0;
										$totalPendapatan=0;
										foreach($jsonDebet as $jsondebet) {
											$number++;
											$totalPendapatan=$totalPendapatan+($jsondebet->acc_debit*1);
									?>
                                    <tr>
                                        <td class="text-left" style="width:80px;"><?php echo $number;?>.</td>
                                        <td class="text-left" style="width:600px;"><?php echo $jsondebet->acc_description;?></td>
                                        <td class="text-right dt-no-sorting"><?php echo number_format($jsondebet->acc_debit);?></td>
                                    </tr>
									<?php
										
										$txt = $txt.'<tr><td>'.$number.'.</td><td>'.$jsondebet->acc_description.'</td><td align="right">'.str_replace(",",".",number_format($jsondebet->acc_debit)).'</tr>';
										}
									?>
										<tr>
											<td colspan="2" class="text-white text-center" style="background-color:#546e7a;color:white;font-weight:bold;">Total Pendapatan</td>
											<td class="text-white text-right" style="background-color:#546e7a;color:white;font-weight:bold;"><?php echo number_format($totalPendapatan);?></td>
										</tr>
										<?php
											$txt = $txt.'<tr><td align="center" colspan="2" style="background-color:#546e7a;color:white;"><b>Total Pendapatan</b></td><td align="right" style="background-color:#546e7a;color:white;"><b>'.str_replace(",",".",number_format($totalPendapatan)).'</b></td></tr>';
											
											$txt = $txt.'</table><p>&nbsp;</p><table border="1">';
											
										?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th class="text-center">No.</th>
                                        <th class="text-center">Deskripsi</th>
                                        <th class="text-center dt-no-sorting">Jumlah (Rp)</th>
                                    </tr>
                                </tfoot>
                            </table>
							</div>
							<br>
                        </div>
						
						
						<!-- Pengeluaran -->
						
						<div class="widget-content widget-content-area br-6 mt-2">
							<div id="dvAccountingTable2" name="dvAccountingTable2">
							<H4 class="m-4 text-danger">Pengeluaran</h4>
                            <table id="range-search" class="display table table-hover" style="width:100%">
                                <tbody>
									<?php
									$arrayAcc=AccountCodeCreditFromAccountingByDate($conn,$dt1,$dt2);
									$jsonAcc=json_decode($arrayAcc);
									$totalPengeluaran=0;
									foreach($jsonAcc as $jsonacc) {
										$accName=GetFieldFromAccountCode($conn,'acc_name',$jsonacc->acc_account_subcode);
									?>
                                    <tr>
                                        <th colspan="3" class="text-left text-black" style="background-color:#bdbdbd;"><?php echo $accName;?></th>
                                    </tr>
										<?php
										
										$txt = $txt.'<tr><td colspan="3"><b>'.$accName.'</b></td></tr>';
										
										$arrayAccSub=AccountSubCodeFromAccountingByDate($conn,$dt1,$dt2,substr($jsonacc->acc_account_subcode,0,5));
										$jsonAccSub=json_decode($arrayAccSub);
										foreach($jsonAccSub as $jsonaccsub) {
											$accSubName=GetFielfFromAccountSubByCode($conn,'acc_subcode_name',$jsonaccsub->acc_account_subcode);
										?>
									<tr>
										<td colspan="3" class="text-left text-black" style="background-color:#e0e0e0;"><?php echo $accSubName;?></td>
									</tr>
									<?php
											$txt = $txt.'<tr><td colspan="3"><b>'.$accSubName.'</b></td></tr>';
											
											$arrayTrx=AccountingAccSubCodeCreditByCode($conn,$dt1,$dt2,$jsonaccsub->acc_account_subcode);
											$jsonTrx=json_decode($arrayTrx);
											$numberTrx=0;
											$subTotal=0;
											foreach($jsonTrx as $jsontrx) {
												$numberTrx++;
												$subTotal=$subTotal+($jsontrx->acc_credit*1);
									?>	
											<tr>
												<td class="text-left text-black"><?php echo $numberTrx;?>.</td>
												<td class="text-left text-black"><?php echo $jsontrx->acc_description;?></td>
												<td class="text-right text-black"><?php echo number_format($jsontrx->acc_credit);?></span></td>
											</tr>
									<?php
												$txt = $txt.'<tr><td>'.$numberTrx.'.</td><td>'.$jsontrx->acc_description.'</td><td align="right">'.str_replace(',','.',number_format($jsontrx->acc_credit)).'</td></tr>';
											}
											$totalPengeluaran=$totalPengeluaran+($jsontrx->acc_credit*1);
									?>
											<tr>
												<td colspan="2" class="text-right text-white" style="background-color:#607d8b;">Sub Total <?php echo $accSubName;?></td>
												<td class="text-right text-white" style="background-color:#607d8b;"><?php echo number_format($subTotal);?></span></td>
											</tr>
									<?php
											$txt = $txt.'<tr><td colspan="2" align="right"><b>Sub Total '.$accSubName.'</b></td></td><td align="right"><b>'.str_replace(',','.',number_format($subTotal)).'</b></td></tr>';
										}
											
									}
									?>
											<tr>
												<td colspan="2" class="text-right text-white" style="background-color:#fb8c00;">Total Pengeluaran</td>
												<td class="text-right text-white" style="background-color:#fb8c00;"><?php echo number_format($totalPengeluaran);?></span></td>
											</tr>
											<?php
											
											$txt = $txt.'<tr><td colspan="2" align="right"><b>Total Pengeluaran</b></td></td><td align="right"><b>'.str_replace(',','.',number_format($totalPengeluaran)).'</b></td></tr>';
											
											$balance=$totalPendapatan-$totalPengeluaran;
											
											$txt = $txt.'<tr><td colspan="2" align="right"><b>B A L A N C E</b></td></td><td align="right"><b>'.str_replace(',','.',number_format($balance)).'</b></td></tr>';
											
											
											$txt = $txt.'</table></body></html>';
											fwrite($myfile, $txt);
											fclose($myfile);
											?>
											<tr>
												<td colspan="2" class="text-right text-white" style="background-color:#283593;">B A L A N C E</td>
												<td class="text-right text-white" style="background-color:#283593;"><?php echo number_format($balance);?></span></td>
											</tr>
                                </tbody>
                            </table>
							</div>
							<br>
                        </div>
						
						
                    </div>

                </div>

                </div>
				
				
        <?php include '../../includes/footer.inc';?>
        </div>
        <!--  END CONTENT AREA  -->

    </div>
    <!-- END MAIN CONTAINER -->
    
    <!-- Modal -->
	<div id="mdlAddAccounting" class="modal animated fadeInRight custo-fadeInRight" role="dialog">
		<div class="modal-dialog modal-lg">
			<!-- Modal content-->
            <div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title">Pembukuan Akuntansi</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <svg aria-hidden="true" xmlns="http://www.w3.org/2000/svg" style="color:red;" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-x"><line x1="18" y1="6" x2="6" y2="18"></line><line x1="6" y1="6" x2="18" y2="18"></line></svg>
                    </button>
                </div>
				<div class="modal-body">
					<p class="modal-text">
						<form name="frmAddAccounting" id="frmAddAccounting" method="post" action="../../actions/fins_add_accounting.php">
								<input type="hidden" id="fins_edit" name="fins_edit">
								<div class="form-row mb-4">
									<div class="form-group col-md-4">
										<label for="inputEmail4">Tanggal</label>
										<input type="date" name="fin_dt" id="fin_dt" value="<?php echo date('Y-m-d');?>" class="form-control text-black" required>
									</div>
									<div class="form-group col-md-8">
										<label for="inputPassword4">Deskripsi</label>
										<input type="text" maxlength="50" class="form-control text-capitalize text-black" id="fin_description" name="fin_description" required>
									</div>
								</div>
								<div class="form-row mb-4">
									<div class="form-group col-md-6">
										<label for="inputAddress">Kode Akun</label>
										<select class="form-control text-black" id="fin_accountcode" name="fin_accountcode" required>
											<option value="" selected disabled></option>
											<?php
											$arrayAccount=FinsCodeAccount($conn,'');
											$jsonAccount=json_decode($arrayAccount);
											foreach($jsonAccount as $jsonaccount) {
												echo '<option value="'.$jsonaccount->acc_code.'">'.$jsonaccount->acc_name.'</option>';
											}
											?>
										</select>
									</div>
									<div class="form-group col-md-6">
										<label for="inputAddress2">Sub Kode Akun</label>
										<div name="dvAccountSubCode" id="dvAccountSubCode">
										<select class="form-control text-black" id="fin_accountsubcode" name="fin_accountsubcode" required>
											<option value="" selected disabled></option>
										</select>
										</div>
									</div>
								</div>
								<div class="form-row mb-4">
									<div class="form-group col-md-4">
										<label for="inputEmail4">Debit (Rp.)</label>
										<input type="text" class="form-control text-right text-black" id="fin_debit" name="fin_debit" value="0">
									</div>
									<div class="form-group col-md-4">
										<label for="inputPassword4">Kredit (Rp.)</label>
										<input type="text" class="form-control text-right text-black" id="fin_credit" name="fin_credit" value="0">
									</div>
									<div class="form-group col-md-4" id="dvStatus" name="dvStatus" style="display:none;">
										<label for="inputPassword4">Status</label>
										<select class="form-control text-black" id="fin_active" name="fin_active">
											<option value="YY" selected>Aktif</option>
											<option value="NN">Hapus</option>
										</select>
									</div>
								</div>
							<div class="text-right">		
								<button type="button" class="btn btn-danger mt-3" onclick="FormOpen('close');">Tutup</button>
								<button type="submit" class="btn btn-primary mt-3">Input</button>
							</div>
						</form>
					</p>
                </div>
            </div>
        </div>
    </div> 
	<!-- End Of Modal -->
    
    <!-- BEGIN GLOBAL MANDATORY SCRIPTS -->
    <script src="<?php echo ROOT_URL;?>assets/js/libs/jquery-3.1.1.min.js"></script>
    <script src="<?php echo ROOT_URL;?>bootstrap/js/popper.min.js"></script>
    <script src="<?php echo ROOT_URL;?>bootstrap/js/bootstrap.min.js"></script>
    <script src="<?php echo ROOT_URL;?>plugins/perfect-scrollbar/perfect-scrollbar.min.js"></script>
    <script src="<?php echo ROOT_URL;?>assets/js/app.js"></script>
    
    <script>
        $(document).ready(function() {
            App.init();
        });
    </script>
    <script src="<?php echo ROOT_URL;?>assets/js/custom.js"></script>
    <!-- END GLOBAL MANDATORY SCRIPTS -->

    <!-- BEGIN PAGE LEVEL SCRIPTS -->
    <script src="<?php echo ROOT_URL;?>plugins/table/datatable/datatables.js"></script>
	<script src="<?php echo ROOT_URL;?>assets/js/scrollspyNav.js"></script>
    <script src="<?php echo ROOT_URL;?>plugins/sweetalerts/sweetalert2.min.js"></script>
    <script src="<?php echo ROOT_URL;?>plugins/sweetalerts/custom-sweetalert.js"></script>
    <script>
        /* Custom filtering function which will search data in column four between two values */
        $.fn.dataTable.ext.search.push(
            function( settings, data, dataIndex ) {
                var min = parseInt( $('#min').val(), 10 );
                var max = parseInt( $('#max').val(), 10 );
                var age = parseFloat( data[3] ) || 0; // use data for the age column
         
                if ( ( isNaN( min ) && isNaN( max ) ) ||
                     ( isNaN( min ) && age <= max ) ||
                     ( min <= age   && isNaN( max ) ) ||
                     ( min <= age   && age <= max ) )
                {
                    return true;
                }
                return false;
            }
        );         
        $(document).ready(function() {
            var table = $('#range-search').DataTable({
                "dom": "<'dt--top-section'<'row'<'col-12 col-sm-6 d-flex justify-content-sm-start justify-content-center'l><'col-12 col-sm-6 d-flex justify-content-sm-end justify-content-center mt-sm-0 mt-3'f>>>" +
        "<'table-responsive'tr>" +
        "<'dt--bottom-section d-sm-flex justify-content-sm-between text-center'<'dt--pages-count  mb-sm-0 mb-3'i><'dt--pagination'p>>",
                "oLanguage": {
                    "oPaginate": { "sPrevious": '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-arrow-left"><line x1="19" y1="12" x2="5" y2="12"></line><polyline points="12 19 5 12 12 5"></polyline></svg>', "sNext": '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-arrow-right"><line x1="5" y1="12" x2="19" y2="12"></line><polyline points="12 5 19 12 12 19"></polyline></svg>' },
                    "sInfo": "Showing page _PAGE_ of _PAGES_",
                    "sSearch": '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-search"><circle cx="11" cy="11" r="8"></circle><line x1="21" y1="21" x2="16.65" y2="16.65"></line></svg>',
                    "sSearchPlaceholder": "Search...",
                   "sLengthMenu": "Results :  _MENU_",
                },
                "stripeClasses": [],
                "lengthMenu": [7, 10, 20, 50],
                "pageLength": 7 
            });             
            // Event listener to the two range filtering inputs to redraw on input
            $('#min, #max').keyup( function() { table.draw(); } );
        } );
    </script>
    <!-- END PAGE LEVEL SCRIPTS -->
	
<script>
$('#frmSearch').submit(function(e) {
	e.preventDefault();
	if(document.getElementById('dt2').value<document.getElementById('dt1').value) {
				const toast = swal.mixin({
					toast: true,
					position: 'top-end',
					showConfirmButton: false,
					timer: 3000,
					padding: '2em'
				  });

				  toast({
					type: 'error',
					title: 'Mohon periksa tanggal !',
					padding: '2em',
				  })
		return false;
	} else {
		document.getElementById('frmSearch').submit();
	}
});

function FormOpen(mode) {
	if(mode=='open') {
		$('#mdlAddAccounting').modal({backdrop: 'static',keyboard: false});
		
	} else {
		$('#mdlAddAccounting').modal('hide');	
	}
}

$('#fin_accountcode').change(function(e) {
	var acc_code=document.getElementById('fin_accountcode').value;
	fetch('fins_codeaccount.php?codeonly='+acc_code)
	.then(response=>response.json())
	.then(responseAccSub=>{
		$("#fin_accountsubcode").empty();
			var opt = document.createElement('option');
			opt.value = '';
			opt.disabled = true;
			opt.selected = true;
			opt.innerHTML = '';
			document.getElementById('fin_accountsubcode').appendChild(opt);
		for(var i=0;i<responseAccSub.length;i++) {
			var opt = document.createElement('option');
			opt.value = responseAccSub[i].acc_subcode;
			opt.innerHTML = responseAccSub[i].acc_subcode_name;
			document.getElementById('fin_accountsubcode').appendChild(opt);
		}
	});
});

function formatRupiah(angka, prefix) {
    var number_string = angka.replace(/[^,\d]/g, '').toString(),
		split = number_string.split(','),
        sisa  = split[0].length % 3,
        rupiah = split[0].substr(0, sisa),
        ribuan = split[0].substr(sisa).match(/\d{3}/gi);
            
	if (ribuan) {
		separator = sisa ? '.' : '';
        rupiah += separator + ribuan.join('.');
	}
        
    rupiah = split[1] != undefined ? rupiah + ',' + split[1] : rupiah;
    return prefix == undefined ? rupiah : (rupiah ? 'Rp. ' + rupiah : '');
}

$('#frmAddAccounting').submit(function(e) {
	var formData = {
	  fins_edit: $("#fins_edit").val(),
	  fin_dt: $("#fin_dt").val(),
      fin_description: $("#fin_description").val(),
	  fin_accountcode: $("#fin_accountcode").val(),
	  fin_accountsubcode: $("#fin_accountsubcode").val(),
	  fin_debit: $("#fin_debit").val(),
	  fin_credit: $("#fin_credit").val(),
	  fin_active: $("#fin_active").val(),
    };

    $.ajax({
      type: "POST",
      url: "../../actions/fins_add_accounting.php",
      data: formData,
      dataType: "json",
      encode: true,
    }).done(function (data) {
		if(data=='success') {
			const toast = swal.mixin({
			toast: true,
			position: 'top-end',
			showConfirmButton: false,
			timer: 1500,
			padding: '2em'
			});

			toast({
			type: 'success',
			title: 'Data Tersimpan !',
			padding: '2em',
			})
			
			$("#fin_accountsubcode").empty();
			$('#frmAddAccounting')[0].reset(); 
			
			fetch('fins_report1_view.php?dt1=<?php echo $_REQUEST['dt1'];?>&dt2=<?php echo $_REQUEST['dt2'];?>')
			.then(response=>response.text())
			.then(responseResult=>{
			document.getElementById('dvAccountingTable').innerHTML=responseResult;
			
			});
			document.getElementById('fin_description').focus();
		
		} else {
			
			const toast = swal.mixin({
			toast: true,
			position: 'top-end',
			showConfirmButton: false,
			timer: 1500,
			padding: '2em'
			});

			toast({
			type: 'error',
			title: 'Gagal menyimpan data !',
			padding: '2em',
			})
			
		}
		
    });

    event.preventDefault();
});

$('#fin_debit').keyup(function(e) {
	document.getElementById('fin_debit').value=formatRupiah(this.value);
});

$('#fin_credit').keyup(function(e) {
	document.getElementById('fin_credit').value=formatRupiah(this.value);
});

$('#mdlAddAccounting').on('hidden.bs.modal', function () {
  $(this).find('#frmAddAccounting')[0].reset(); 
})
</script>	
</body>

</html>
<?php include '../../includes/connection_close.inc';?>