<?php
include '../../includes/connection.inc';
include '../../query/maxim.sql';
include '../../includes/header.inc';

$monthName=array('Januari','Februari','Maret','April','Mei','Juni','Juli','Agustus','September','Oktober','November','Desember');
?>
    
    
    <!-- BEGIN PAGE LEVEL STYLES -->
    <link rel="stylesheet" type="text/css" href="<?php echo ROOT_URL;?>plugins/table/datatable/datatables.css">
    <link rel="stylesheet" type="text/css" href="<?php echo ROOT_URL;?>plugins/table/datatable/dt-global_style.css">
	<link href="<?php echo ROOT_URL;?>plugins/animate/animate.css" rel="stylesheet" type="text/css" />
    <script src="<?php echo ROOT_URL;?>plugins/sweetalerts/promise-polyfill.js"></script>
    <link href="<?php echo ROOT_URL;?>plugins/sweetalerts/sweetalert2.min.css" rel="stylesheet" type="text/css" />
    <link href="<?php echo ROOT_URL;?>plugins/sweetalerts/sweetalert.css" rel="stylesheet" type="text/css" />
    <link href="<?php echo ROOT_URL;?>assets/css/components/custom-sweetalert.css" rel="stylesheet" type="text/css" />
	<link href="<?php echo ROOT_URL;?>assets/css/components/custom-modal.css" rel="stylesheet" type="text/css" />
	
    <!-- END PAGE LEVEL STYLES -->
</head>
<?php
$arrayUid = explode('|',$_SESSION['MAXIM_AUTH']);
CheckUserAccessCurrentMenuPage($conn,$arrayUid[1],'MNU013');
?>
<body class="sidebar-noneoverflow">
    <!-- BEGIN LOADER -->
    <div id="load_screen"> <div class="loader"> <div class="loader-content">
        <div class="spinner-grow align-self-center"></div>
    </div></div></div>
    <!--  END LOADER -->
    
    <!--  BEGIN NAVBAR  -->
    <?php include '../../includes/navbar.inc';?>
    <!--  END NAVBAR  -->

    <!--  BEGIN MAIN CONTAINER  -->
    <div class="main-container" id="container">

        <div class="overlay"></div>
        <div class="cs-overlay"></div>
        <div class="search-overlay"></div>

        <!--  BEGIN SIDEBAR  -->
        <?php include '../../includes/sidebar.inc';?>
        <!--  END SIDEBAR  -->

        <?php
		if($_REQUEST['dt']=='') {
			$dt=date('Y-m-d');
		} else {
			$dt=date('Y-m-d',strtotime($_REQUEST['dt']));
		}
		if($_REQUEST['time1']=='') {
			$time1='01:00';
		} else {
			$time1=date('H:i',strtotime($_REQUEST['time1']));
		}
		if($_REQUEST['time2']=='') {
			$time2=date('H:i');
		} else {
			$time2=date('H:i',strtotime($_REQUEST['time2']));
		}
		?>
		<!--  BEGIN CONTENT AREA  -->
        <div id="content" class="main-content">
            <div class="layout-px-spacing">

                <div class="row layout-top-spacing" id="cancel-row">
                
                    <div class="col-xl-12 col-lg-12 col-sm-12 layout-spacing">
						<div class="row">
							<div class="col"><h3 style="color:<?php echo BASE_COLOR;?>;">Rekap Laporan Gym <span style="font-size:15px" class="text-primary">(Berdasarkan Login)</span></h3></div>
						</div>
                        <div class="widget-content widget-content-area br-6">
							<div class="row m-3">
								<div class="col-sm-6"><div id="excel" name="excel" style="display:none;"><img src="<?php echo ROOT_URL;?>assets/img/excel.png" style="width:30px;height:30px;"> <a href="../../archieves/rekap_gym.xls" download>Download</a></div></div>
								<div class="col-sm-6 text-right"><button title="Parameter Laporan" onclick="SearchOpen('open');" class="btn btn-dark mb-2 mr-2 rounded-circle"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-search"><circle cx="11" cy="11" r="8"></circle><line x1="21" y1="21" x2="16.65" y2="16.65"></line></svg></button></div>
							</div>
							<div class="row">
								<div class="col-sm-6">
									<label class="m-4 text-secondary">Tanggal Laporan : <?php echo date('d-m-Y');?><br>
									Jam Laporan : <?php echo $time1.' s/d '.$time2;?></label>
								</div>
								<div class="col-sm-6 text-right">
									<label class="m-4 text-secondary">Oleh : <?php echo $arrayUid[0];?></label>
								</div>
							</div>
                            <table id="range-search" class="display table table-hover" style="width:100%">
                                <thead>
                                    <tr>
										<th class="text-center">No.</th>
                                        <th class="text-center">Tanggal</th>
                                        <th class="text-center">Member Id</th>
                                        <th class="text-center dt-no-sorting">Nama Customer/Member</th>
										<th class="text-center dt-no-sorting">Deskripsi</th>
										<th class="text-center dt-no-sorting">Jumlah (Rp)</th>
                                    </tr>
                                </thead>
                                <tbody>
									<?php
									$arrayGym=GymTransactionByDateAndLogin($conn,$dt,$time1,$time2,$arrayUid[1]);
									$jsonGym=json_decode($arrayGym);
									$total=0;
									$myfile = fopen("../../archieves/rekap_gym.xls", "w") or die("Unable to open file!");
									
									$txt = '<html><body><table border="0"><tr><td>Tanggal Cetak</td><td>:&nbsp;'.date('d-m-Y',strtotime($dt)).'</td></tr><tr><td>Jam </td><td>:&nbsp;'.$time1.' s/d '.$time2.'</td></tr><tr><td>Oleh</td><td>:&nbsp;'.$arrayUid[0].'</td></tr></table><br><br>
									<table border="1">
										<tr>
											<td style="background-color:black;color:white;font-weight:bold;">No</td>
											<td style="background-color:black;color:white;font-weight:bold;">Tanggal</td>
											<td style="background-color:black;color:white;font-weight:bold;">Member Id</td>
											<td style="background-color:black;color:white;font-weight:bold;">Nama Customer/Member</td>
											<td style="background-color:black;color:white;font-weight:bold;">Deskripsi</td>
											<td  style="background-color:black;color:white;font-weight:bold;">Jumlah (Rp)</td>
										</tr>';
									
									$number=0;
									$total=0;
									foreach($jsonGym as $jsongym) {
										$number++;
										
										$total=$total+($jsongym->trx_amount*1);
										if($jsongym->trx_source=='GYMTRX') {
											$trxMemberUid=GetFieldFromMemberTransactionByTrxCode($conn,'trx_member_uid',$jsongym->trx_code);
											$memberName=GetFieldFromMember($conn,'member_fullname',$trxMemberUid);		
											if(substr($jsongym->trx_code,0,2)=='MT') {
												$memberTypeName=GetFieldFromMemberType($conn,'type_name',$jsongym->item_category);
												$memberDisc=$jsongym->item_code;
												$desc='Pembayaran Tipe '.$memberTypeName.' Periode '.$jsongym->item_qty.' Bulan';
											} else if(substr($jsongym->trx_code,0,2)=='NC') {
												$desc='Biaya Kartu Baru';
											} else if(substr($jsongym->trx_code,0,2)=='RG') {
												$desc='Regular Visit';	
											} else if(substr($jsongym->trx_code,0,2)=='RC') {
												$desc='Biaya Penggantian Kartu';
											}
										} else {
											$trxMemberUid=GetFieldFromMemberTrainee($conn,'member_uid',$jsongym->trx_code);
											$memberName=GetFieldFromMember($conn,'member_fullname',$trxMemberUid);
											$memberTypeName=GetFieldFromTraineeByCode($conn,'packet_name',$jsongym->item_category). '('.GetFieldFromTraineeByCode($conn,'packet_session',$jsongym->item_category).' X)';
											$memberDisc=0;
											$desc='Pembayaran Pelatihan '.$memberTypeName;
										}
									?>
										<tr>
											<td class="text-black"><?php echo $number;?>.</td>
											<td class="text-black"><?php echo date('d-m-Y',strtotime($jsongym->trx_created));?></td>
											<td class="text-primary" style="font-weight:bold;"><?php echo $trxMemberUid;?></td>
											<td class="text-black"><?php echo $memberName;?></td>
											<td class="text-black"><?php echo $desc;?></td>
											<td style="background-color:#fff59d;font-weight:bold;" class="text-right text-black"><?php echo number_format($jsongym->trx_amount);?></td>
										</tr>
									<?php
									
										$txt = $txt.'<tr>
											<td>'.$number.'.</td>
											<td>'.date('d-m-Y',strtotime($jsongym->trx_created)).'</td>
											<td>'.$trxMemberUid.'</td>
											<td>'.$memberName.'</td>
											<td>'.$desc.'</td>
											<td align="right">'.$jsongym->trx_amount.'</td>
											</tr>';
									}
										$txt = $txt.'<tr><td style="background-color:black;color:white;font-weight:bold;" colspan="5" align="right">T o t a l&nbsp;</td><td style="background-color:black;color:white;font-weight:bold;" align="right">'.$total.'</td></tr>';
										$txt = $txt.'</table><p>&nbsp;</p>';
										
									?>
										<tr>
											<td class="text-center" style="background-color:#455a64;color:#fff;font-weight:bold" colspan="5">Total Pendapatan</td>
											<td class="text-right" style="background-color:#455a64;color:#fff;font-weight:bold"><?php echo number_format($total);?></td>
										</tr>
									<?php
										if(count($jsongym)>0) {
											echo "<script>document.getElementById('excel').style.display='';</script>";
									?>		
											<tr>
											<td colspan="6" class="text-center text-black">Tidak ada data</td>
											</tr>
										
									<?php
										}
									?>
									
                                </tbody>
                                <tfoot>
                                    <tr>
										<th class="text-center">No.</th>
                                        <th class="text-center">Tanggal</th>
                                        <th class="text-center">Member Id</th>
                                        <th class="text-center dt-no-sorting">Nama Customer/Member</th>
										<th class="text-center dt-no-sorting">Deskripsi</th>
										<th class="text-center dt-no-sorting">Jumlah (Rp)</th>
                                    </tr>
                                </tfoot>
                            </table>
						
                        </div>
						
						<div class="row" style="margin-top:20px;">
							<div class="col"><h3 style="color:blue;">Rekap Pembayaran Channel</h3><small style="font-size:12px;color:red;font-weight:bold">Rekap ini berdasarkan total transaksi GYM & Cafe Per Chnanel</small></div>
						</div>
						<div class="widget-content widget-content-area br-6 mt-3" style="background-color:#f3e5f5;">
							<table id="range-search" class="display table table-hover" style="width:100%">
                                <thead>
                                    <tr>
										<th class="text-center">Channel</th>
										<th class="text-center dt-no-sorting">Jumlah (Rp)</th>
                                    </tr>
                                </thead>
                                <tbody>
									<?php
									$txt = $txt.'<h3>Rekap ini berdasarkan total transaksi GYM & Cafe Per Channel</h3><table border="2"><tr><td align="center" style="background-color:black;color:white;font-weight:bold;">Channel</td><td align="center" style="background-color:black;color:white;font-weight:bold;">Jumlah (Rp)</td></tr>';
									
									$arrayChannel=SumPaymentByChannelAndUid($conn,$dt,$time1,$time2,$arrayUid[1],'GYM');
									$jsonChannel=json_decode($arrayChannel);
									$totalChannel=0;
									foreach($jsonChannel as $jsonchannel) {
										echo '<tr><td class="text-black">'.$jsonchannel->pt_name.'</td><td class="text-black" align="right">'.number_format($jsonchannel->total).'</td></tr>';
										$txt = $txt.'<tr><td>'.$jsonchannel->pt_name.'</td><td align="right">'.$jsonchannel->total.'</td></tr>';
										$totalChannel=$totalChannel+($jsonchannel->total*1);
									}
										$txt = $txt.'<tr><td style="background-color:black;color:white;font-weight:bold;">T o t a l</td><td style="background-color:black;color:white;font-weight:bold;" align="right">'.$totalChannel.'</td></tr></table></body></html>';
										fwrite($myfile, $txt);
										fclose($myfile);
									?>
										<tr>
											<td class="text-center" style="background-color:#455a64;color:#fff;font-weight:bold">Total</td>
											<td class="text-right" style="background-color:#455a64;color:#fff;font-weight:bold"><?php echo number_format($totalChannel);?></td>
										</tr>
                                </tbody>
                                <tfoot>
                                    <tr>
										<th class="text-center">Channel</th>
										<th class="text-center dt-no-sorting">Jumlah (Rp)</th>
                                    </tr>
                                </tfoot>
                            </table>
						
                        </div>
						
                    </div>

                </div>

                </div>
        <?php include '../../includes/footer.inc';?>
        </div>
        <!--  END CONTENT AREA  -->

    </div>
    <!-- END MAIN CONTAINER -->
    
	<!-- Modal -->
	<div id="mdlSearchParams" class="modal animated slideInUp custo-slideInUp" role="dialog">
		<div class="modal-dialog">
			<!-- Modal content-->
            <div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title">Laporan Rekap Gym</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close" >
						<svg aria-hidden="true" xmlns="http://www.w3.org/2000/svg" style="color:red;" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-x"><line x1="18" y1="6" x2="6" y2="18"></line><line x1="6" y1="6" x2="18" y2="18"></line></svg>
                    </button>
                </div>
                <div class="modal-body">
					<form method="get" name="frmSearch" id="frmSearch" action="daily_maxim.php">
					<p class="modal-text">
						<div class="input-group mb-4">
                            <div class="input-group-prepend">
								<span class="input-group-text" id="basic-addon5">Tanggal</span>
                            </div>
                            <input type="date" class="form-control" id="dt" name="dt" value="<?php echo $dt;?>" required>
                        </div>
						<div class="input-group mb-4">
									<div class="input-group-prepend">
										<span class="input-group-text" id="basic-addon5"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-watch"><circle cx="12" cy="12" r="7"></circle><polyline points="12 9 12 12 13.5 13.5"></polyline><path d="M16.51 17.35l-.35 3.83a2 2 0 0 1-2 1.82H9.83a2 2 0 0 1-2-1.82l-.35-3.83m.01-10.7l.35-3.83A2 2 0 0 1 9.83 1h4.35a2 2 0 0 1 2 1.82l.35 3.83"></path></svg></span>
									</div>
										<input type="time" class="form-control" id="time1" name="time1" value="<?php echo $time1;?>"  required>
									&nbsp;&nbsp;<b style="margin-top:9px;">S/D</b>&nbsp;&nbsp;
									<div class="input-group-prepend">
										<span class="input-group-text" id="basic-addon5"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-watch"><circle cx="12" cy="12" r="7"></circle><polyline points="12 9 12 12 13.5 13.5"></polyline><path d="M16.51 17.35l-.35 3.83a2 2 0 0 1-2 1.82H9.83a2 2 0 0 1-2-1.82l-.35-3.83m.01-10.7l.35-3.83A2 2 0 0 1 9.83 1h4.35a2 2 0 0 1 2 1.82l.35 3.83"></path></svg></span>
									</div>
										<input type="time" class="form-control" id="time2" name="time2" value="<?php echo $time2;?>"  required>
                            
                        </div>
					</p>
                </div>
                <div class="modal-footer md-button">
					<button class="btn" data-dismiss="modal"><i class="flaticon-cancel-12"></i> Tutup</button>
                    <button type="submit" class="btn btn-primary">Rekap Laporan</button>
                </div>
				</form>
            </div>
        </div>
    </div>
	<!-- End of Modal -->
    
    <!-- BEGIN GLOBAL MANDATORY SCRIPTS -->
    <script src="<?php echo ROOT_URL;?>assets/js/libs/jquery-3.1.1.min.js"></script>
    <script src="<?php echo ROOT_URL;?>bootstrap/js/popper.min.js"></script>
    <script src="<?php echo ROOT_URL;?>bootstrap/js/bootstrap.min.js"></script>
    <script src="<?php echo ROOT_URL;?>plugins/perfect-scrollbar/perfect-scrollbar.min.js"></script>
    <script src="<?php echo ROOT_URL;?>assets/js/app.js"></script>
    
    <script>
        $(document).ready(function() {
            App.init();
        });
    </script>
    <script src="<?php echo ROOT_URL;?>assets/js/custom.js"></script>
    <!-- END GLOBAL MANDATORY SCRIPTS -->

    <!-- BEGIN PAGE LEVEL SCRIPTS -->
    <script src="<?php echo ROOT_URL;?>plugins/table/datatable/datatables.js"></script>
	<script src="<?php echo ROOT_URL;?>assets/js/scrollspyNav.js"></script>
    <script src="<?php echo ROOT_URL;?>plugins/sweetalerts/sweetalert2.min.js"></script>
    <script src="<?php echo ROOT_URL;?>plugins/sweetalerts/custom-sweetalert.js"></script>
	<script src="<?php echo ROOT_URL;?>plugins/flatpickr/flatpickr.js"></script>
    <script src="<?php echo ROOT_URL;?>plugins/flatpickr/custom-flatpickr.js"></script>
    <script>
        /* Custom filtering function which will search data in column four between two values */
        $.fn.dataTable.ext.search.push(
            function( settings, data, dataIndex ) {
                var min = parseInt( $('#min').val(), 10 );
                var max = parseInt( $('#max').val(), 10 );
                var age = parseFloat( data[3] ) || 0; // use data for the age column
         
                if ( ( isNaN( min ) && isNaN( max ) ) ||
                     ( isNaN( min ) && age <= max ) ||
                     ( min <= age   && isNaN( max ) ) ||
                     ( min <= age   && age <= max ) )
                {
                    return true;
                }
                return false;
            }
        );         
        $(document).ready(function() {
            var table = $('#range-search').DataTable({
                "dom": "<'dt--top-section'<'row'<'col-12 col-sm-6 d-flex justify-content-sm-start justify-content-center'l><'col-12 col-sm-6 d-flex justify-content-sm-end justify-content-center mt-sm-0 mt-3'f>>>" +
        "<'table-responsive'tr>" +
        "<'dt--bottom-section d-sm-flex justify-content-sm-between text-center'<'dt--pages-count  mb-sm-0 mb-3'i><'dt--pagination'p>>",
                "oLanguage": {
                    "oPaginate": { "sPrevious": '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-arrow-left"><line x1="19" y1="12" x2="5" y2="12"></line><polyline points="12 19 5 12 12 5"></polyline></svg>', "sNext": '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-arrow-right"><line x1="5" y1="12" x2="19" y2="12"></line><polyline points="12 5 19 12 12 19"></polyline></svg>' },
                    "sInfo": "Showing page _PAGE_ of _PAGES_",
                    "sSearch": '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-search"><circle cx="11" cy="11" r="8"></circle><line x1="21" y1="21" x2="16.65" y2="16.65"></line></svg>',
                    "sSearchPlaceholder": "Search...",
                   "sLengthMenu": "Results :  _MENU_",
                },
                "stripeClasses": [],
                "lengthMenu": [7, 10, 20, 50],
                "pageLength": 7 
            });             
            // Event listener to the two range filtering inputs to redraw on input
            $('#min, #max').keyup( function() { table.draw(); } );
        } );
    </script>
    <!-- END PAGE LEVEL SCRIPTS -->
	
<script>
$('#frmSearchs').submit(function(e) {
	e.preventDefault();
	
});

function SearchOpen(mode) {
	if(mode=='open') {
		$('#mdlSearchParams').modal({backdrop: 'static',keyboard: false});
		
	} else {
		$('#mdlSearchParams').modal('hide');	
	}
}

</script>	
</body>

</html>
<?php include '../../includes/connection_close.inc';?>